/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tecgraf.javautils.gui.table.ColumnGroup;

public class GroupableTableHeader
extends JTableHeader {
    private List<ColumnGroup> columnGroups;
    private Map<TableColumn, Map<Rectangle, Object>> columnGroupY = new HashMap<TableColumn, Map<Rectangle, Object>>();
    private Map<TableColumn, List<ColumnGroup>> groupsByColumn;

    public GroupableTableHeader(TableColumnModel model) {
        super(model);
        this.setDefaultRenderer(this.createGroupRenderer());
        this.setUI(new GroupableTableHeaderUI());
        this.setReorderingAllowed(false);
    }

    @Override
    public void updateUI() {
        this.setUI(this.ui);
        TableCellRenderer renderer = this.getDefaultRenderer();
        if (renderer instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)renderer));
        }
    }

    @Override
    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = false;
    }

    public void addColumnGroup(ColumnGroup group) {
        if (this.columnGroups == null) {
            this.columnGroups = new ArrayList<ColumnGroup>();
        }
        this.columnGroups.add(group);
        this.groupsByColumn = null;
    }

    public void clearColumnGroups() {
        this.columnGroups = null;
        this.groupsByColumn = null;
    }

    public List<ColumnGroup> getColumnGroups(TableColumn col) {
        if (this.groupsByColumn == null) {
            this.fillGroupsByColumnMap();
        }
        if (this.groupsByColumn == null) {
            return null;
        }
        return this.groupsByColumn.get(col);
    }

    public String getColumnNameAt(Point point) {
        Object value = this.getColumnValueAt(point);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Object getColumnValueAt(Point point) {
        int col = this.getColumnModel().getColumnIndexAtX(point.x);
        if (col < 0) {
            return null;
        }
        TableColumn aColumn = this.columnModel.getColumn(col);
        Map<Rectangle, Object> yNames = this.columnGroupY.get(aColumn);
        for (Map.Entry<Rectangle, Object> entry : yNames.entrySet()) {
            Rectangle rect = entry.getKey();
            if (rect.y > point.y || rect.y + rect.height < point.y) continue;
            return entry.getValue();
        }
        return null;
    }

    protected Object getGroupValue(ColumnGroup cGroup) {
        return cGroup.getHeaderValue();
    }

    protected Object getColumnValue(TableColumn aColumn) {
        return aColumn.getHeaderValue();
    }

    protected TableCellRenderer createGroupRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setHorizontalAlignment(0);
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
    }

    private void fillGroupsByColumnMap() {
        if (this.columnGroups == null) {
            return;
        }
        this.groupsByColumn = new HashMap<TableColumn, List<ColumnGroup>>();
        HashSet<TableColumn> colsSet = new HashSet<TableColumn>(Collections.list(this.getColumnModel().getColumns()));
        HashSet<ColumnGroup> validGroups = new HashSet<ColumnGroup>();
        for (ColumnGroup cGroup : this.columnGroups) {
            this.fillFromGroup(cGroup, new ArrayList<ColumnGroup>(), colsSet, validGroups);
        }
        this.columnGroups.clear();
        this.columnGroups.addAll(validGroups);
    }

    private void fillFromGroup(ColumnGroup cGroup, List<ColumnGroup> allGroups, HashSet<TableColumn> modelColumns, Collection<ColumnGroup> validGroups) {
        List<Object> columns = cGroup.getAllColumns();
        allGroups.add(cGroup);
        for (Object col : columns) {
            ArrayList<ColumnGroup> antecessorsList = new ArrayList<ColumnGroup>();
            antecessorsList.addAll(allGroups);
            if (ColumnGroup.class.isInstance(col)) {
                this.fillFromGroup((ColumnGroup)ColumnGroup.class.cast(col), antecessorsList, modelColumns, validGroups);
                continue;
            }
            if (!modelColumns.contains(col)) continue;
            this.groupsByColumn.put((TableColumn)TableColumn.class.cast(col), (List<ColumnGroup>)antecessorsList);
            validGroups.add(antecessorsList.get(0));
        }
    }

    protected class GroupableTableHeaderUI
    extends BasicTableHeaderUI {
        protected GroupableTableHeaderUI() {
        }

        @Override
        protected MouseInputListener createMouseInputListener() {
            return super.createMouseInputListener();
        }

        public JTableHeader getHeader() {
            return this.header;
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            long width = 0L;
            Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn aColumn = enumeration.nextElement();
                width += (long)aColumn.getPreferredWidth();
            }
            return this.createHeaderSize(width);
        }

        private Dimension createHeaderSize(long width) {
            TableColumnModel columnModel = this.header.getColumnModel();
            if ((width += (long)(columnModel.getColumnMargin() * columnModel.getColumnCount())) > Integer.MAX_VALUE) {
                width = Integer.MAX_VALUE;
            }
            return new Dimension((int)width, this.getHeaderHeight());
        }

        private int getHeaderHeight() {
            int height = 0;
            TableColumnModel columnModel = this.header.getColumnModel();
            HashMap<ColumnGroup, Integer> cGroupsHeight = new HashMap<ColumnGroup, Integer>();
            for (int column = 0; column < columnModel.getColumnCount(); ++column) {
                List<ColumnGroup> cGroups;
                TableColumn aColumn = columnModel.getColumn(column);
                Object value = GroupableTableHeader.this.getColumnValue(aColumn);
                int cHeight = 0;
                if (value != null) {
                    Component comp = this.getHeaderComponent(aColumn);
                    cHeight = comp.getPreferredSize().height;
                }
                if ((cGroups = ((GroupableTableHeader)this.header).getColumnGroups(aColumn)) != null) {
                    for (ColumnGroup cGroup : cGroups) {
                        Integer groupHeight = (Integer)cGroupsHeight.get(cGroup);
                        if (groupHeight == null) {
                            groupHeight = this.getHeight(cGroup);
                            cGroupsHeight.put(cGroup, groupHeight);
                        }
                        cHeight += groupHeight.intValue();
                    }
                }
                height = Math.max(height, cHeight);
            }
            return height;
        }

        public int getHeight(ColumnGroup group) {
            Component comp = this.getHeaderComponent(group);
            int height = comp.getPreferredSize().height;
            return height;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            TableColumnModel columnModel = this.header.getColumnModel();
            if (columnModel == null || columnModel.getColumnCount() == 0) {
                return;
            }
            List<Integer> heights = this.getPreferredHeights();
            ArrayList<Integer> ys = new ArrayList<Integer>();
            int preferredHeight = 0;
            for (int height : heights) {
                ys.add(preferredHeight);
                preferredHeight += height;
            }
            GroupableTableHeader.this.columnGroupY.clear();
            HashMap<ColumnGroup, Rectangle> groupRectangles = new HashMap<ColumnGroup, Rectangle>();
            Dimension size = this.header.getSize();
            int x = 0;
            Enumeration<TableColumn> columns = this.header.getColumnModel().getColumns();
            while (columns.hasMoreElements()) {
                TableColumn aColumn = columns.nextElement();
                List<ColumnGroup> cGroups = ((GroupableTableHeader)this.header).getColumnGroups(aColumn);
                int y = (Integer)ys.get(cGroups == null ? 0 : cGroups.size());
                int height = size.height - y;
                int width = aColumn.getWidth();
                Rectangle cellRect = new Rectangle(x, y, width, height);
                this.setCellPosition(aColumn, cellRect, GroupableTableHeader.this.getColumnValue(aColumn));
                this.paintCell(g, cellRect, this.getHeaderComponent(aColumn));
                if (cGroups != null) {
                    for (int inx = 0; inx < cGroups.size(); ++inx) {
                        ColumnGroup cGroup = cGroups.get(inx);
                        Rectangle groupRect = (Rectangle)groupRectangles.get(cGroup);
                        if (groupRect == null) {
                            int groupY = (Integer)ys.get(inx);
                            int groupHeight = heights.get(inx);
                            int groupWidth = cGroup.getWidth();
                            groupRect = new Rectangle(x, groupY, groupWidth, groupHeight);
                            groupRectangles.put(cGroup, groupRect);
                            this.paintCell(g, groupRect, this.getHeaderComponent(cGroup));
                        }
                        this.setCellPosition(aColumn, groupRect, GroupableTableHeader.this.getGroupValue(cGroup));
                    }
                }
                x += cellRect.width;
            }
        }

        private void setCellPosition(TableColumn column, Rectangle cellRect, Object cellValue) {
            LinkedHashMap<Rectangle, Object> yNames = (LinkedHashMap<Rectangle, Object>)GroupableTableHeader.this.columnGroupY.get(column);
            if (yNames == null) {
                yNames = new LinkedHashMap<Rectangle, Object>();
                GroupableTableHeader.this.columnGroupY.put(column, yNames);
            }
            yNames.put(cellRect, cellValue);
        }

        private void paintCell(Graphics g, Rectangle cellRect, Component component) {
            this.rendererPane.add(component);
            this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }

        private Component getHeaderComponent(ColumnGroup group) {
            TableCellRenderer renderer = group.getHeaderRenderer();
            if (renderer == null) {
                renderer = GroupableTableHeader.this.getDefaultRenderer();
            }
            return renderer.getTableCellRendererComponent(GroupableTableHeader.this.table, GroupableTableHeader.this.getGroupValue(group), false, false, -1, -1);
        }

        private Component getHeaderComponent(TableColumn column) {
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = GroupableTableHeader.this.getDefaultRenderer();
            }
            return renderer.getTableCellRendererComponent(GroupableTableHeader.this.table, GroupableTableHeader.this.getColumnValue(column), false, false, -1, GroupableTableHeader.this.table.convertColumnIndexToView(column.getModelIndex()));
        }

        private List<Integer> getPreferredHeights() {
            ArrayList<Integer> heights = new ArrayList<Integer>();
            if (GroupableTableHeader.this.columnGroups != null && !GroupableTableHeader.this.columnGroups.isEmpty()) {
                for (ColumnGroup group : GroupableTableHeader.this.columnGroups) {
                    this.fillPreferredHeights(group, 0, heights);
                }
            } else {
                int height = 0;
                Enumeration<TableColumn> columns = GroupableTableHeader.this.getColumnModel().getColumns();
                while (columns.hasMoreElements()) {
                    int columnHeight = this.getHeaderComponent((TableColumn)columns.nextElement()).getPreferredSize().height;
                    height = Math.max(height, columnHeight);
                }
                heights.add(height);
            }
            return heights;
        }

        private void fillPreferredHeights(ColumnGroup group, int level, List<Integer> heights) {
            if (heights.size() < level) {
                throw new IllegalArgumentException("heights.size() < level");
            }
            if (GroupableTableHeader.this.table.getColumnCount() == 0) {
                return;
            }
            if (heights.size() == level) {
                heights.add(0);
            }
            int currentHeight = heights.get(level);
            int groupHeight = this.getHeaderComponent((ColumnGroup)group).getPreferredSize().height;
            heights.set(level, Math.max(currentHeight, groupHeight));
            int childLevel = level + 1;
            for (Object child : group.getAllColumns()) {
                if (child instanceof TableColumn) {
                    TableColumn column = (TableColumn)child;
                    if (heights.size() < childLevel) {
                        throw new IllegalArgumentException("heights.size() < level");
                    }
                    if (heights.size() == childLevel) {
                        heights.add(0);
                    }
                    int childCurrentHeight = heights.get(childLevel);
                    if (column.getHeaderValue() == null) continue;
                    int childHeight = this.getHeaderComponent((TableColumn)column).getPreferredSize().height;
                    heights.set(childLevel, Math.min(childCurrentHeight, childHeight));
                    continue;
                }
                this.fillPreferredHeights((ColumnGroup)child, childLevel, heights);
            }
        }
    }
}

