package textviewer.actions;

import java.awt.Window;

import javax.swing.Action;

import textviewer.TextViewer;
import textviewer.actions.core.SaveAsAction;
import csdk.v1_0.api.filesystem.IFile;

/**
 * Ao de abertura do arquivo
 * 
 * @author Tecgraf/PUC-Rio
 */
public class SaveAsProjectAction extends SaveAsAction {

  /**
   * {@inheritDoc}
   */
  @Override
  protected IFile selectFile() throws Exception {
    TextViewer textViewer = getApplication();
    String[] fileTypes = new String[] { "TEXT" };
    Window frm = textViewer.getApplicationFrame();
    IFile file =
      textViewer.browseProjectFileInSaveMode(fileTypes, false, null, frm);
    if (file == null) {
      return null;
    }
    return file;
  }

  /**
   * Construtor
   * 
   * @param textViewer a aplicao
   */
  public SaveAsProjectAction(TextViewer textViewer) {
    super(textViewer);
    putValue(Action.NAME, textViewer.getString("save.as.project.item"));
    putValue(Action.SMALL_ICON, textViewer.getImageIcon(new String[] {
        "actions", "SaveAs16.gif" }));
  }
}
