/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Component;
import java.awt.FontMetrics;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import tecgraf.javautils.gui.table.MultiLineLabelHeaderRenderer;

public class RowHeader
extends JList {
    private JTable table;
    private List<? extends Object> rowNames;
    private String rowHeaderTitle;
    private List<String> rowHeaderTooltips;

    public static void setRowHeader(JScrollPane pane, JTable table, List<? extends Object> rowNames, String rowHeaderTitle) {
        pane.setRowHeaderView(new RowHeader(pane, table, rowNames, rowHeaderTitle));
    }

    public RowHeader(JScrollPane pane, JTable table, List<? extends Object> rowNames, String rowHeaderTitle) {
        this.table = table;
        this.rowNames = rowNames;
        this.rowHeaderTitle = rowHeaderTitle;
        this.setModel(this.getRowHeaderModel());
        this.setFixedCellWidth(this.getMaxRowNameWidth() + 20);
        this.setFixedCellHeight(table.getRowHeight());
        this.setBackground(pane.getBackground());
        this.setCellRenderer(new RowHeaderRenderer(2));
        MultiLineLabelHeaderRenderer renderer = new MultiLineLabelHeaderRenderer();
        renderer.setTitle(table, rowHeaderTitle);
        pane.setCorner("UPPER_LEFT_CORNER", renderer);
        table.getModel().addTableModelListener(new ModelListener());
    }

    public List<? extends Object> getRowNames() {
        return this.rowNames;
    }

    ListModel getRowHeaderModel() {
        return new AbstractListModel(){

            @Override
            public int getSize() {
                return RowHeader.this.rowNames.size();
            }

            @Override
            public Object getElementAt(int index) {
                return RowHeader.this.rowNames.get(index);
            }
        };
    }

    public void setRowNames(List<? extends Object> rowNames) {
        this.rowNames = rowNames;
        this.setFixedCellWidth(this.getMaxRowNameWidth() + 20);
        this.setModel(this.getRowHeaderModel());
    }

    private int getMaxRowNameWidth() {
        FontMetrics metrics = this.getFontMetrics(this.table.getTableHeader().getFont());
        int maxWidth = metrics.stringWidth(this.rowHeaderTitle);
        for (int i = 0; i < this.rowNames.size(); ++i) {
            String rowName = this.rowNames.get(i).toString();
            int width = metrics.stringWidth(rowName);
            maxWidth = Math.max(maxWidth, width);
        }
        return maxWidth;
    }

    public void setRowHeaderTooltips(List<String> tooltips) {
        this.rowHeaderTooltips = tooltips;
    }

    private class ModelListener
    implements TableModelListener {
        private ModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent ev) {
            if ((ev.getType() == 1 || ev.getType() == -1) && ev.getColumn() == -1) {
                RowHeader.this.repaint();
            }
        }
    }

    private class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(int horizontalAlignment) {
            JTableHeader header = RowHeader.this.table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setFont(header.getFont());
            this.setHorizontalAlignment(horizontalAlignment);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            if (RowHeader.this.rowHeaderTooltips != null && index < RowHeader.this.rowHeaderTooltips.size()) {
                this.setToolTipText((String)RowHeader.this.rowHeaderTooltips.get(index));
            }
            return this;
        }
    }
}

