/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui;

import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;

public class SortedComboBoxModel<T extends Comparable<T>>
extends DefaultComboBoxModel {
    private Comparator<T> comparator;
    private boolean hasSpecialElement = false;

    public SortedComboBoxModel() {
    }

    public SortedComboBoxModel(boolean hasSpecialElement) {
        this.hasSpecialElement = hasSpecialElement;
    }

    public SortedComboBoxModel(T[] items) {
        this((Comparable[])items, null);
    }

    public SortedComboBoxModel(Comparator<T> comparator) {
        this(null, comparator);
        this.comparator = comparator;
    }

    public SortedComboBoxModel(T[] items, Comparator<T> comparator) {
        this.comparator = comparator;
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                this.addElement(items[i]);
            }
        }
    }

    @Override
    public void addElement(Object element) {
        this.insertElementAt(element, 0);
    }

    @Override
    public void insertElementAt(Object element, int index) {
        int initial;
        Comparable comparable;
        Comparable object;
        if (!(element instanceof Comparable)) {
            throw new IllegalArgumentException("Par\u00e2metro deve implementar Comparable.");
        }
        int size = this.getSize();
        for (index = initial = this.hasSpecialElement ? 1 : 0; index < size && !(this.comparator != null ? this.comparator.compare(object = (Comparable)this.getElementAt(index), (Comparable)element) > 0 : (comparable = (Comparable)this.getElementAt(index)).compareTo(element) > 0); ++index) {
        }
        index = size == 0 ? 0 : index;
        super.insertElementAt(element, index);
    }

    public static void main(String[] args) {
        SortedComboBoxModel model = new SortedComboBoxModel((Comparable[])new String[]{"5", "7", "2", "1", "0"});
        model.addElement("3");
        model.addElement("4");
        model.addElement("8");
        int size = model.getSize();
        ArrayList<String> list = new ArrayList<String>();
        for (int n = 0; n < size; ++n) {
            list.add((String)model.getElementAt(n));
        }
        System.out.println(((Object)list).toString());
    }
}

