/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.crud.gui.main;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import tecgraf.javautils.gui.crud.IRegistrationDescriptor;
import tecgraf.javautils.gui.crud.RegistrationBundle;
import tecgraf.javautils.gui.crud.gui.editbuttons.RegistrationEditButtonsPanel;
import tecgraf.javautils.gui.crud.gui.edition.RegistrationEditionPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationModeListener;
import tecgraf.javautils.gui.crud.gui.table.RegistrationTablePanel;

public class RegistrationMainPanel<M, I>
extends JPanel {
    private final List<RegistrationModeListener> modeListeners = new ArrayList<RegistrationModeListener>();
    private final IRegistrationDescriptor<M, I> descriptor;
    private final RegistrationTablePanel<M, I> tablePanel;
    private Mode mode;
    private final RegistrationEditButtonsPanel<M, I> buttonsPanel;
    private final ResourceBundle bundle;

    public String getString(String tag) {
        if (this.bundle == null) {
            return "!!! " + tag;
        }
        try {
            return this.bundle.getString(tag);
        }
        catch (MissingResourceException mre) {
            return "[[" + tag + "]]";
        }
    }

    public RegistrationMainPanel(IRegistrationDescriptor<M, I> descriptor, Locale locale) {
        this(descriptor, new RegistrationBundle(locale));
    }

    public RegistrationMainPanel(IRegistrationDescriptor<M, I> descriptor, ResourceBundle bundle) {
        if (bundle == null) {
            throw new RuntimeException("null bundle not allowed!");
        }
        this.descriptor = descriptor;
        this.bundle = bundle;
        this.tablePanel = new RegistrationTablePanel<M, I>(this, descriptor);
        RegistrationEditionPanel<M, I> edtPanel = descriptor.getRegistrationEditPanel(this);
        this.buttonsPanel = new RegistrationEditButtonsPanel<M, I>(this, edtPanel, descriptor);
        this.mode = Mode.VIEW;
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        rightPanel.add("Center", edtPanel);
        rightPanel.add("South", this.buttonsPanel);
        JSplitPane split = new JSplitPane(1);
        split.add(this.tablePanel);
        split.add(rightPanel);
        split.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add("Center", split);
        edtPanel.clearIHC();
        edtPanel.setReadOnlyIHC(true);
        this.setMode(Mode.VIEW);
    }

    public M getSelectedObject() {
        return this.tablePanel.getSelectedObject();
    }

    public IRegistrationDescriptor<M, I> getDescriptor() {
        return this.descriptor;
    }

    public I getSelectedIHCObject() {
        return this.descriptor.toIHCObject(this.getSelectedObject());
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        Mode oldMode = this.mode;
        this.mode = mode;
        this.notifyModeListeners(oldMode, mode);
    }

    private void notifyModeListeners(Mode oldMode, Mode newMode) {
        for (RegistrationModeListener l : this.modeListeners) {
            l.modeChanged(oldMode, newMode);
        }
    }

    public void addModeListener(RegistrationModeListener listener) {
        this.modeListeners.add(listener);
    }

    public void delModeListener(RegistrationModeListener listener) {
        this.modeListeners.remove(listener);
    }

    public void refreshGUI() {
        this.tablePanel.updateTable();
    }

    public void signalObjectEdited(boolean flag) {
        this.buttonsPanel.signalObjectEdited(flag);
    }

    public static enum Mode {
        ADD,
        VIEW,
        EDIT;

    }
}

