/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.crud.gui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.crud.IRegistrationDescriptor;
import tecgraf.javautils.gui.crud.RegistrationImages;
import tecgraf.javautils.gui.crud.gui.actions.RegistrationAddAction;
import tecgraf.javautils.gui.crud.gui.actions.RegistrationObjectAction;
import tecgraf.javautils.gui.crud.gui.actions.RegistrationSelObjectDeleteAction;
import tecgraf.javautils.gui.crud.gui.actions.RegistrationSelObjectEditAction;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationModeListener;
import tecgraf.javautils.gui.crud.gui.table.RegistrationTableModel;
import tecgraf.javautils.gui.crud.gui.table.RegistrationTableMouseListener;
import tecgraf.javautils.gui.crud.gui.table.RegistrationTableRenderer;
import tecgraf.javautils.gui.table.SortableTable;

public class RegistrationTablePanel<M, I>
extends JPanel {
    private final SortableTable table = new SortableTable();
    private final JScrollPane scrollPane;
    private final IRegistrationDescriptor<M, I> descriptor;
    private final JButton othersButton = new JButton();
    private final RegistrationSelObjectEditAction<M, I> editAction;
    private final RegistrationAddAction<M, I> addAction;
    private final RegistrationSelObjectDeleteAction<M, I> delAction;
    private final RegistrationMainPanel<M, I> mainPanel;

    private final void updateTableColumns() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int numColumns = columnModel.getColumnCount();
        for (int c = 0; c < numColumns; ++c) {
            TableColumn column = columnModel.getColumn(c);
            column.setPreferredWidth(this.descriptor.getColumnWidth(c));
        }
    }

    public final M getSelectedObject() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        Object object = this.table.getValueAt(row, 0);
        return (M)object;
    }

    private void initTableAttributes() {
        RegistrationTableModel<M, I> model = new RegistrationTableModel<M, I>(this.descriptor);
        this.table.setModel(model);
        RegistrationTableRenderer<M, I> renderer = new RegistrationTableRenderer<M, I>(this.descriptor);
        this.table.setDefaultRenderer(Object.class, renderer);
        this.table.sort(0, SortOrder.ASCENDING);
        this.table.setSelectionMode(0);
        if (model.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.table.setAutoResizeMode(4);
    }

    private void updateTableAttributes() {
        RegistrationTableModel<M, I> model = new RegistrationTableModel<M, I>(this.descriptor);
        this.table.setModel(model);
        this.table.sort(0, SortOrder.ASCENDING);
        if (model.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    private JPanel buildButtonsPanel(JButton addButton, JButton delButton, JButton editButton, JButton othersButton) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)addButton, new GBC(0, 0).center().none().insets(2));
        panel.add((Component)delButton, new GBC(2, 0).center().none().insets(2));
        panel.add((Component)new JPanel(), new GBC(3, 0).horizontal().insets(2));
        panel.add((Component)othersButton, new GBC(4, 0).center().none().insets(2));
        addButton.setText(null);
        editButton.setText(null);
        delButton.setText(null);
        GUIUtils.matchPreferredSizes(addButton, delButton, editButton);
        return panel;
    }

    public RegistrationTablePanel(RegistrationMainPanel<M, I> mainPanel, IRegistrationDescriptor<M, I> descriptor) {
        this.mainPanel = mainPanel;
        this.descriptor = descriptor;
        this.scrollPane = new JScrollPane(this.table);
        this.editAction = new RegistrationSelObjectEditAction<M, I>(mainPanel);
        this.addAction = new RegistrationAddAction<M, I>(mainPanel);
        this.delAction = new RegistrationSelObjectDeleteAction<M, I>(mainPanel);
        JButton delButton = new JButton(this.delAction);
        JButton addButton = new JButton(this.addAction);
        JButton editButton = new JButton(this.editAction);
        this.initOthersButton();
        this.setLayout(new BorderLayout());
        JPanel buttonsPanel = this.buildButtonsPanel(addButton, delButton, editButton, this.othersButton);
        this.add("Center", this.scrollPane);
        this.add("South", buttonsPanel);
        this.initTableAttributes();
        this.setAddModeListener(mainPanel);
        this.setEditModeListener(mainPanel);
        this.setViewModeListener(mainPanel);
        this.setSelectionListener(mainPanel);
        this.updateTableColumns();
        this.updateTableAttributes();
        RegistrationTableMouseListener<M, I> lst = new RegistrationTableMouseListener<M, I>(this, descriptor);
        this.table.addMouseListener(lst);
        this.updateSelectionButtons();
        this.setMinimumSize(new Dimension(300, 300));
    }

    private void updateSelectionButtons() {
        int numObjects = this.descriptor.getNumObjects();
        M selectedObject = this.getSelectedObject();
        boolean flag = numObjects > 0 && selectedObject != null && this.table.isEnabled();
        this.editAction.setEnabled(flag);
        this.delAction.setEnabled(flag);
        this.othersButton.setEnabled(flag);
        if (flag) {
            List<RegistrationObjectAction<M, I>> othersMenuActions = this.descriptor.getOthersMenuActions(this.mainPanel, selectedObject);
            this.othersButton.setEnabled(othersMenuActions != null && !othersMenuActions.isEmpty());
        }
    }

    private void setSelectionListener(final RegistrationMainPanel<M, I> mainPanel) {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RegistrationTablePanel.this.updateSelectionButtons();
                mainPanel.setMode(RegistrationMainPanel.Mode.VIEW);
            }
        });
    }

    private void setAddModeListener(RegistrationMainPanel<M, I> mainPanel) {
        final RegistrationTablePanel self = this;
        mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode != RegistrationMainPanel.Mode.ADD) {
                    return;
                }
                self.setActive(false);
            }
        });
    }

    private void setEditModeListener(RegistrationMainPanel<M, I> mainPanel) {
        final RegistrationTablePanel self = this;
        mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode != RegistrationMainPanel.Mode.EDIT) {
                    return;
                }
                self.setActive(false);
            }
        });
    }

    private void setViewModeListener(RegistrationMainPanel<M, I> mainPanel) {
        final RegistrationTablePanel self = this;
        mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode != RegistrationMainPanel.Mode.VIEW) {
                    return;
                }
                self.setActive(true);
            }
        });
    }

    private void setActive(boolean flag) {
        this.addAction.setEnabled(flag);
        this.table.setEnabled(flag);
        this.updateSelectionButtons();
    }

    private void initOthersButton() {
        this.othersButton.setText(this.mainPanel.getString("button.others"));
        this.othersButton.setIcon(RegistrationImages.ICON_DOWN_4);
        this.othersButton.setHorizontalTextPosition(4);
        this.othersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedObject = RegistrationTablePanel.this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                RegistrationMainPanel mainPanel = RegistrationTablePanel.this.getMainPanel();
                List actions = RegistrationTablePanel.this.descriptor.getOthersMenuActions(mainPanel, selectedObject);
                if (actions == null || actions.size() == 0) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                for (RegistrationObjectAction action : actions) {
                    menu.add(action);
                }
                int y = RegistrationTablePanel.this.othersButton.getHeight();
                menu.show(RegistrationTablePanel.this.othersButton, 0, y);
            }
        });
    }

    private AbstractTableModel getTableModel() {
        return (AbstractTableModel)this.table.getModel();
    }

    public void updateTable() {
        AbstractTableModel model = this.getTableModel();
        model.fireTableDataChanged();
        if (model.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    RegistrationMainPanel<M, I> getMainPanel() {
        return this.mainPanel;
    }

    AbstractAction getEditAction() {
        return this.editAction;
    }

    AbstractAction getDeleteAction() {
        return this.delAction;
    }

    IRegistrationDescriptor<M, I> getDescriptor() {
        return this.descriptor;
    }
}

