/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.PermissionException;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.FileChannelRequestInfo;
import tecgraf.ftc.server.FileServer;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.GetOperationState;
import tecgraf.ftc.server.states.State;

public abstract class OpenState
implements State {
    private InternalState currentState;
    private int fileIdSize;
    private byte[] fileId;
    private FileChannel fileChannel;
    private ErrorCode errorCode;
    private boolean readOnly;
    protected static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    protected OpenState(boolean readOnly) {
        this.readOnly = readOnly;
        this.currentState = InternalState.INITIAL;
    }

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                int bytesRead = channel.read(buffer);
                if (bytesRead < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesRead > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.fileIdSize = buffer.get() & 0xFF;
                buffer.clear();
                this.currentState = InternalState.IDENTIFIER_SIZE_RECEIVED;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Tamanho do identificador lido " + this.fileIdSize);
                }
            }
            case IDENTIFIER_SIZE_RECEIVED: {
                buffer.limit(this.fileIdSize);
                int bytesRead = channel.read(buffer);
                if (bytesRead < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesRead > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.fileId = new byte[this.fileIdSize];
                buffer.get(this.fileId);
                buffer.clear();
                this.currentState = InternalState.IDENTIFIER_RECEIVED;
                this.writing = true;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Identificador lido: " + DatatypeConverter.printHexBinary((byte[])this.fileId));
                }
                FileChannelRequestInfo fileChannelInfo = session.getFileChannelInfo();
                FileServer fileServer = session.getFileServer();
                try {
                    this.fileChannel = fileServer.createFileChannel(fileChannelInfo.getRequester(), fileChannelInfo.getFileId(), this.readOnly);
                    this.errorCode = this.fileChannel == null ? ErrorCode.FILE_NOT_FOUND : ErrorCode.OK;
                }
                catch (FailureException e) {
                    fileServer.exceptionRaised(e, fileChannelInfo.getFileId());
                    this.errorCode = ErrorCode.FAILURE;
                }
                catch (PermissionException e) {
                    fileServer.exceptionRaised(e, fileChannelInfo.getFileId());
                    this.errorCode = ErrorCode.NO_PERMISSION;
                }
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case IDENTIFIER_RECEIVED: {
                int bytesWritten = channel.write(buffer);
                if (bytesWritten < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesWritten > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.clear();
                this.currentState = InternalState.ERROR_CODE_SENT;
                this.writing = false;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
                }
                if (!this.errorCode.equals((Object)ErrorCode.OK)) {
                    return false;
                }
                session.setFileChannel(this.fileChannel);
                session.setCurrentState(new GetOperationState());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    protected static enum InternalState {
        INITIAL,
        IDENTIFIER_SIZE_RECEIVED,
        IDENTIFIER_RECEIVED,
        ERROR_CODE_SENT;

    }
}

