/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import ibase.rest.model.algorithm.v1.AlgorithmVersion;
import ibase.rest.model.algorithm.v1.User;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Algorithm {
    private String id = null;
    private String name = null;
    private String description = null;
    private User whoCreated = null;
    private AlgorithmVersion lastVersion = null;
    private List<AlgorithmVersion> versions = new ArrayList<AlgorithmVersion>();

    public Algorithm id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of an algorithm.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Algorithm name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the algorithm.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Algorithm description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the algorithm.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Algorithm whoCreated(User whoCreated) {
        this.whoCreated = whoCreated;
        return this;
    }

    @ApiModelProperty(value="")
    public User getWhoCreated() {
        return this.whoCreated;
    }

    public void setWhoCreated(User whoCreated) {
        this.whoCreated = whoCreated;
    }

    public Algorithm lastVersion(AlgorithmVersion lastVersion) {
        this.lastVersion = lastVersion;
        return this;
    }

    @ApiModelProperty(value="")
    public AlgorithmVersion getLastVersion() {
        return this.lastVersion;
    }

    public void setLastVersion(AlgorithmVersion lastVersion) {
        this.lastVersion = lastVersion;
    }

    public Algorithm versions(List<AlgorithmVersion> versions) {
        this.versions = versions;
        return this;
    }

    public Algorithm addVersionsItem(AlgorithmVersion versionsItem) {
        this.versions.add(versionsItem);
        return this;
    }

    @ApiModelProperty(value="The versions of this algoritm.")
    public List<AlgorithmVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<AlgorithmVersion> versions) {
        this.versions = versions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Algorithm algorithm = (Algorithm)o;
        return Objects.equals(this.id, algorithm.id) && Objects.equals(this.name, algorithm.name) && Objects.equals(this.description, algorithm.description) && Objects.equals(this.whoCreated, algorithm.whoCreated) && Objects.equals(this.lastVersion, algorithm.lastVersion) && Objects.equals(this.versions, algorithm.versions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.whoCreated, this.lastVersion, this.versions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Algorithm {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    whoCreated: ").append(this.toIndentedString(this.whoCreated)).append("\n");
        sb.append("    lastVersion: ").append(this.toIndentedString(this.lastVersion)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

