/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import ibase.rest.model.algorithm.v1.ParameterGroup;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AlgorithmConfiguration {
    private String command = null;
    private ExecutionTypeEnum executionType = null;
    private List<ParameterGroup> groups = new ArrayList<ParameterGroup>();

    public AlgorithmConfiguration command(String command) {
        this.command = command;
        return this;
    }

    @ApiModelProperty(value="The execution command for submission. At the submission, this command will be followed by the list of parameters provided by the user.")
    @JsonProperty(value="command")
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public AlgorithmConfiguration executionType(ExecutionTypeEnum executionType) {
        this.executionType = executionType;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="execution_type")
    public ExecutionTypeEnum getExecutionType() {
        return this.executionType;
    }

    public void setExecutionType(ExecutionTypeEnum executionType) {
        this.executionType = executionType;
    }

    public AlgorithmConfiguration groups(List<ParameterGroup> groups) {
        this.groups = groups;
        return this;
    }

    @ApiModelProperty(value="The group of parameters")
    @JsonProperty(value="groups")
    public List<ParameterGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<ParameterGroup> groups) {
        this.groups = groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlgorithmConfiguration algorithmConfiguration = (AlgorithmConfiguration)o;
        return Objects.equals(this.command, algorithmConfiguration.command) && Objects.equals((Object)this.executionType, (Object)algorithmConfiguration.executionType) && Objects.equals(this.groups, algorithmConfiguration.groups);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.command, this.executionType, this.groups});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlgorithmConfiguration {\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    executionType: ").append(this.toIndentedString((Object)this.executionType)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExecutionTypeEnum {
        SIMPLE("simple"),
        MULTIPLE("multiple");

        private String value;

        private ExecutionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

