/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.client.v1;

import ibase.rest.api.client.v1.ClientApiService;
import ibase.rest.api.client.v1.NotFoundException;
import ibase.rest.api.client.v1.factories.ClientApiServiceFactory;
import ibase.rest.model.client.v1.UrlToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/client")
@Produces(value={"application/json"})
@Api(description="the client API")
public class ClientApi {
    private final ClientApiService delegate = ClientApiServiceFactory.getClientApi();

    @GET
    @Path(value="/launcher")
    @Produces(value={"application/json"})
    @ApiOperation(value="An URL to a Desktop Client.", notes="", response=UrlToken.class, tags={"Client Launcher"})
    @ApiResponses(value={@ApiResponse(code=200, message="An URL to a Desktop Client.", response=UrlToken.class), @ApiResponse(code=400, message="If login or password are not provided (or are empty values).", response=UrlToken.class), @ApiResponse(code=401, message="Invalid login/password", response=UrlToken.class)})
    public Response clientLauncherGet(@ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.clientLauncherGet(locale, securityContext);
    }

    @GET
    @Path(value="/rest/{token}")
    @Produces(value={"application/json"})
    @ApiOperation(value="An URL to the Client-side HTTP server.", notes="", response=String.class, tags={"Client Launcher"})
    @ApiResponses(value={@ApiResponse(code=200, message="An URL to a Desktop Client.", response=String.class), @ApiResponse(code=400, message="If token is not provided (or are empty values).", response=String.class), @ApiResponse(code=401, message="Invalid token", response=String.class)})
    public Response clientRestTokenGet(@ApiParam(value="the client token", required=true) @PathParam(value="token") String token, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.clientRestTokenGet(token, locale, securityContext);
    }
}

