/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.project.v1.impl;

import ibase.authentication.AuthenticationService;
import ibase.authentication.ParseException;
import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.rest.api.project.v1.NotFoundException;
import ibase.rest.api.project.v1.impl.ProjectsApiServiceImpl;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/links")
@Produces(value={"application/json;"})
public class LinksApi {
    public static final String RESOURCE_BUNDLE = "properties.language.LinksApi";
    private static final Logger logger = Logger.getLogger("LinksApi");

    @GET
    @Path(value="/download/{token}/{project_id}/{file_path}")
    @Produces(value={"application/octet-stream"})
    public Response linksTokenProjectIdFilesFilePathMetadataGet(@PathParam(value="project_id") String projectId, @PathParam(value="file_path") String filePath, @PathParam(value="token") String token, @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        try {
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            authenticationService.parserToken(token, null);
            ProjectsApiServiceImpl serviceImpl = new ProjectsApiServiceImpl();
            return serviceImpl.projectsProjectIdFilesFileIdGet(projectId, filePath, locale, securityContext);
        }
        catch (ParseException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((String)RESOURCE_BUNDLE, (String)locale).message("links.token.invalid", new String[0]));
        }
    }
}

