/*
 * Decompiled with CFR 0.152.
 */
package ibase.common.v2;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class JsonUtil {
    public static Map<String, Object> jsonToMap(JsonObject json) {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (json != JsonObject.NULL) {
            retMap = JsonUtil.toMap(json);
        }
        return retMap;
    }

    public static JsonObject jsonFromString(String jsonObjectStr) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonObjectStr));
        JsonObject object = jsonReader.readObject();
        jsonReader.close();
        return object;
    }

    private static Map<String, Object> toMap(JsonObject object) throws JsonException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : object.keySet()) {
            List<Object> value = object.get((Object)key);
            if (value instanceof JsonArray) {
                value = JsonUtil.toList((JsonArray)value);
            } else if (value instanceof JsonObject) {
                value = JsonUtil.toMap((JsonObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    private static List<Object> toList(JsonArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JsonArray) {
                value = JsonUtil.toList((JsonArray)value);
            } else if (value instanceof JsonObject) {
                value = JsonUtil.toMap((JsonObject)value);
            }
            list.add(value);
        }
        return list;
    }
}

