package tecgraf.javautils.ant.input;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

import org.apache.tools.ant.input.InputRequest;

/**
 *  um <code>InputHandler</code> usado para entrada de texto
 * com mltiplas linhas para o <code>input</code> do Ant.
 * Exibe um dilogo com o campo onde o usurio pode digitar um texto de uma 
 * linha. Ao teclar <code>Enter</code> ou acionar o boto, o texto digitado  
 * transferido para o resultado da task de <code>input</code> do Ant.
 * 
 * @author mjulia
 *
 */
public class MultilineTextInputHandler extends TextInputHandler {

  /**
   * Cria o campo para entrada de dados com mltiplas linhas.
   * @param text o texto default
   * @param label o componente rtulo do campo
   * @return o componente <code>JTextArea<code> criado
   */
  protected JTextComponent makeTextComponent(String text, JLabel label) {
    JTextArea field = new JTextArea(text, 20, 40);
    label.setLabelFor(field);
    return field;  
  }
  
  /**
   * Atribui os listeners aos componentes de entrada de texto e 
   * de ao de confirmao.
   * 
   * @param request o objeto que representa a requisio de dados para o usurio,
   *                no qual ser atribudo o contedo do texto do componente
   */
  protected void setEventListeners(final InputRequest request) {
    btnSubmit.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        commitResult(request);
      }
    });
  }
}
