package tecgraf.javautils.ant.input;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.text.JTextComponent;

import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputRequest;

/**
 * � um <code>InputHandler</code> usado para entrada de dados no 
 * <code>input</code> do Ant.
 * Exibe um di�logo com o campo onde o usu�rio pode digitar um texto de uma 
 * linha. Ao teclar <code>Enter</code> ou acionar o bot�o, o texto digitado � 
 * transferido para o resultado da task de <code>input</code> do Ant.
 * 
 * @author mjulia
 *
 */
public class TextInputHandler extends DefaultInputHandler {
  /**
   * O di�logo que cont�m o componente para entrada de dados.
   */
  protected JDialog dlgInput;

  /**
   * O r�tulo do componente de entrada de dados.
   */
  protected JLabel lblInput;

  /**
   * O componente para entrada de dados.
   */
  protected JTextComponent fldInput;

  /**
   * O bot�o de confirma��o da entrada de dados.
   */
  protected JButton btnSubmit;
  
  /**
   * {@inheritDoc}
   */
  public void handleInput(InputRequest request) {
    build (request);
    setEventListeners(request);
    dlgInput.pack();
    dlgInput.setVisible(true);
  }
 
  /**
   * Cria o di�logo que possui um componente de texto para entrada de dados.
   * O bot�o de confirma��o faz com que o texto do componente seja passado como
   * sa�da desse <code>InputHandler</code>.
   * 
   * @param request o objeto que representa a requisi��o de dados para o usu�rio,
   *                no qual ser� atribu�do o conte�do do texto do componente
   */
  protected void build(InputRequest request) {
    lblInput = makeLabel(getPrompt(request));
    fldInput = makeTextComponent(request.getInput(), lblInput);
    btnSubmit = makeButton("OK");
    dlgInput = makeDialog(request.getPrompt());
    dlgInput.setModal(true);
  }
  
  /**
   * Cria o campo de texto para entrada de dados.
   * @param text o texto default
   * @param label o componente r�tulo do campo
   * @return o componente <code>JTextField<code> criado
   */
  protected JTextComponent makeTextComponent(String text, JLabel label) {
    JTextField field = new JTextField(text);
    field.setPreferredSize(label.getPreferredSize());
    label.setLabelFor(field);
    return field;  
  }
  
  /**
   * Cria o r�tulo do campo de entrada de dados.
   * @param text o texto do r�tulo
   * @return o componente <code>JLabel</code> criado
   */
  protected JLabel makeLabel(String text) {
    JLabel label = new JLabel(text);
    return label;  
  }
  
  /**
   * Cria o bot�o de confirma��o de entrada de dados.
   * @param text o texto do bot�o
   * @return o componente <code>JButton</code> criado
   */
  protected JButton makeButton(String text) {
    JButton button = new JButton(text);
    return button;
  }
  
  /**
   * Cria o di�logo com os componentes para entrada e confirma��o.
   * @param title o t�tulo do di�logo
   * @return o componente <code>JDialog</code> criado
   */
  protected JDialog makeDialog(String title) {
    JDialog dialog = new JDialog();
    dialog.getContentPane().setLayout(new GridBagLayout());
    GridBagConstraints c = new GridBagConstraints();
    c.insets = new Insets(5, 5, 5, 5);
    c.gridx = 0;
    c.gridy = 0;
    c.anchor = GridBagConstraints.WEST;
    dialog.getContentPane().add(lblInput, c);
    
    c.insets = new Insets(0, 5, 0, 5);
    c.gridy = 1;
    c.fill = GridBagConstraints.HORIZONTAL;
    dialog.getContentPane().add(new JScrollPane(fldInput), c);

    c.insets = new Insets(0, 5, 5, 5);
    c.gridx = 0;
    c.gridy = 2;
    c.gridwidth = 2;
    c.fill = GridBagConstraints.NONE;
    c.anchor = GridBagConstraints.CENTER;
    dialog.getContentPane().add(btnSubmit, c);
    
    return dialog;
  }

  /**
   * Atribui os listeners aos componentes de entrada de texto e 
   * de a��o de confirma��o.
   * 
   * @param request o objeto que representa a requisi��o de dados para o usu�rio,
   *                no qual ser� atribu�do o conte�do do texto do componente
   */
  protected void setEventListeners(final InputRequest request) {
    btnSubmit.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        commitResult(request);
      }
    });

    fldInput.addKeyListener(new KeyAdapter() {
      public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == KeyEvent.VK_ENTER) {
          commitResult(request);
        }
      }
    });
  }
  
  /**
   * Coloca o texto que o usu�rio entrou no request que � passado
   * para o input do ant. Fecha o di�logo.
   * @param request a requisi��o de entrada
   */
  protected void commitResult(final InputRequest request) {
    String result = fldInput.getText();
    request.setInput(result.length()==0 ? null : result);
    dlgInput.dispose();
  }
  
}
