/*
 * $Id$
 */
package tecgraf.javautils.ant.taskdefs;

import java.text.MessageFormat;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;

/**
 * 
 * Ant task que executa a promoo da verso mantida no arquivo
 * version.properties. Exemplo de promoo de major version:
 * 
 * <promote versionfile="version.properties" update="major-version"
 * addproperty="out" showreleaseversion="true"/>
 * 
 * O atributo update pode ter os valores [major|minor|release]-version. A
 * propriedade out  criada com a string representando a verso promovida. O
 * atributo showreleaseversion indica se a verso de release deve ser mostrada
 * (1.0.0 ao invs de 1.0 apenas)
 * 
 * @author Tecgraf/PUC-Rio
 * 
 */
public class Promote extends Task {

  private String update;
  private String versionfile;
  private String addproperty;
  private boolean showreleaseversion = false;

  private Version version;

  /**
   * @param addproperty nome da propriedade a ser criada com a verso de sada
   */
  public void setAddproperty(String addproperty) {
    this.addproperty = addproperty;
  }

  /**
   * @param versionFile o arquivo de verso
   */
  public final void setVersionfile(String versionFile) {
    this.versionfile = versionFile;
  }

  /**
   * @param showreleaseversion true para exibir verso de release
   */
  public final void setShowreleaseversion(boolean showreleaseversion) {
    this.showreleaseversion = showreleaseversion;
  }

  /**
   * @param update the update to set
   */
  public final void setUpdate(String update) {
    this.update = update;
  }

  /**
   * Verifica o input
   */
  private void verifyInput() {
    String msgp = "Atributo {0}  obrigatrio";
    if (versionfile == null)
      getProject().fireBuildFinished(
        new BuildException(MessageFormat.format(msgp, "versionfile")));
    if (update == null)
      getProject().fireBuildFinished(
        new BuildException(MessageFormat.format(msgp, "update")));
    if (addproperty == null)
      getProject().fireBuildFinished(
        new BuildException(MessageFormat.format(msgp, "addproperty")));
  }

  @Override
  public void execute() throws BuildException {

    verifyInput();
    version = new Version(versionfile);

    String newVersion;

    if (update.equals("major-version"))
      newVersion = version.incMajorVersion();
    else if (update.equals("minor-version"))
      newVersion = version.incMinorVersion();
    else if (update.equals("release-version"))
      newVersion = version.incReleaseVersion();
    else
      throw new BuildException("Atributo update invlido.");

    InputHandler handler = getProject().getInputHandler();
    InputRequest request =
      new InputRequest("Digite a nova verso [" + newVersion + "]");
    handler.handleInput(request);

    boolean valid = true;

    if (!request.getInput().equals(""))
      valid = version.parse(request.getInput());

    if (valid) {
      getProject().setProperty(addproperty,
        version.getFormattedVersion(showreleaseversion));
      version.updateProperties();
    }
    else
      getProject().setProperty(addproperty, request.getInput());

  }

}
