/* 
 * $Id$ 
 */
package tecgraf.javautils.ant.taskdefs;

import java.text.MessageFormat;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;


/**
 * Task para apenas ler a verso
 * 
 * @author Tecgraf/PUC-Rio
 *
 */
public class ReadVersion extends Task {
  
  private String versionfile;
  private String addproperty;
  private boolean formatted;
  private boolean showreleaseversion;
  
  public void setAddproperty(String addproperty) {
    this.addproperty = addproperty ;
  }

  public final void setVersionfile(String versionfile) {
    this.versionfile = versionfile;
  }
  
  public final void setFormatted(boolean formatted) {
    this.formatted = formatted;
  }
  
  public final void setShowreleaseversion(boolean showreleaseversion) {
    this.showreleaseversion = showreleaseversion;
  }

  private void verifyInput() {
    String msgp = "Atributo {0}  obrigatrio";
    if (versionfile == null)
      getProject().fireBuildFinished(new BuildException(MessageFormat.format(msgp, "versionfile")));
    if (addproperty == null)
      getProject().fireBuildFinished(new BuildException(MessageFormat.format(msgp, "addproperty")));
 }
  
  @Override
  public void execute() throws BuildException {
    try {
    verifyInput();    
    Version version = new Version(versionfile);
    if (!formatted)
      getProject().setProperty(addproperty, version.getCurrentVersion());
    else
      getProject().setProperty(addproperty, version.getFormattedVersion(showreleaseversion));
    }
    catch(Throwable t) {
      t.printStackTrace();
    }
  }
    
}
