package tecgraf.javautils.ant.taskdefs;

import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.util.GlobPatternMapper;

import java.io.File;

/**
 * Essa classe foi criada com o nico propsito de fornecer uma alternativa 
 * implementao padro da task <javac>: o comportamento original, de restringir
 *  compilao apenas s classes desatualizadas,  substituda aqui; todos os
 * arquivos-fonte do diretrio de origem so compilados nesta verso.
 * Apenas um mtodo, alm do construtor, foi alterado: scanDir.
 * O restante da classe  uma cpia da classe Javac.
 *
 * Compila arquivos fontes em Java. Pode usar os seguintes argumentos:
 * <ul>
 * <li>sourcedir
 * <li>destdir
 * <li>deprecation
 * <li>classpath
 * <li>bootclasspath
 * <li>extdirs
 * <li>optimize
 * <li>debug
 * <li>encoding
 * <li>target
 * <li>depend
 * <li>vebose
 * <li>failonerror
 * <li>includeantruntime
 * <li>includejavaruntime
 * <li>source
 * <li>compiler
 * </ul>
 * Desses argumentos, o <b>sourcedir</b> e <b>destdir</b> so obrigatrios.
 *
 * @author Leonardo Abreu de Barros $
 * @version 1.0 $  - @date: 2003/07/30 11:43:59 $
 */

public class TecJavac extends Javac {

  /**
   * Verso Tecgraf para a tarefa de compilao de arquivos Java no ant.
   */
  public TecJavac() {
    super();
  }

  /**
   * Esse foi o nico mtodo alterado. Ao invs de carregar a classe 
   * SourceFileScanner, uma verso "tecgraf"  fornecida, que no restringe
   * a lista de arquivos-fonte.
   * O GlobPatternMapper  dispensvel.
   *
   * ANTIGA IMPLEMENTAO:
   * Scans the directory looking for source files to be compiled.
   * The results are returned in the class variable compileList
   */
  protected void scanDir(File srcDir, File destDir, String[] files) {
    GlobPatternMapper m = new GlobPatternMapper();
    m.setFrom("*.java");
    m.setTo("*.class");
    TecSourceFileScanner sfs = new TecSourceFileScanner(this);
    File[] newFiles = sfs.restrictAsFiles(files, srcDir, destDir, m);

    if (newFiles.length > 0) {
       File[] newCompileList = new File[compileList.length +
          newFiles.length];
       System.arraycopy(compileList, 0, newCompileList, 0,
          compileList.length);
       System.arraycopy(newFiles, 0, newCompileList,
          compileList.length, newFiles.length);
       compileList = newCompileList;
    }
  }
}
