package tecgraf.javautils.ant.taskdefs;

import org.apache.tools.ant.util.*;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;

import java.io.File;
import java.util.Vector;

/**
 * this class provides utility methods to process resources
 *
 * @author <a href="mailto:levylambert@tiscali-dsl.de">Antoine Levy-Lambert</a>
 * @since Ant 1.5.2
 */
public class TecResourceUtils extends ResourceUtils {

  /**                                                                      {
   * tells which source files should be reprocessed based on the
   * last modification date of target files
   * @param logTo where to send (more or less) interesting output
   * @param source array of resources bearing relative path and last
   * modification date
   * @param mapper filename mapper indicating how to find the target
   * files
   * @param targets object able to map as a resource a relative path
   * at <b>destination</b>
   * @return array containing the source files which need to be
   * copied or processed, because the targets are out of date or do
   * not exist
   */
  public static Resource[] selectAllSources(ProjectComponent logTo,
                                            Resource[] source,
                                            FileNameMapper mapper,
                                            ResourceFactory targets) {

    Vector<Resource> vresult = new Vector<Resource>();
    for (int counter = 0; counter < source.length; counter++) {
      String[] targetnames = 
              mapper.mapFileName(source[counter].getName()
                               .replace('/', File.separatorChar));
      if (targetnames != null) {
        for (int ctarget = 0; ctarget < targetnames.length;ctarget++) {
          Resource atarget = targets.getResource(targetnames[ctarget]
                                     .replace(File.separatorChar, '/'));
          /* 
           * Como pretendemos recompilar sempre todas as classes,
           * no h mais necessidade de verificar se elas esto
           * desatualizadas ou no. Todas sero adicionadas ao vetor
           * de arquivos "compilveis".
           */
          logTo.log(source[counter].getName() + " added as " 
                    + atarget.getName() , Project.MSG_VERBOSE);
          vresult.addElement(source[counter]);
        }
      } else {
        logTo.log(source[counter].getName() 
                  + " skipped - don\'t know how to handle it",
                  Project.MSG_VERBOSE);
      }
    }
    Resource[] result= new Resource[vresult.size()];
    vresult.copyInto(result);
    return result;
  }
}
