package tecgraf.javautils.ant.taskdefs;

import org.apache.tools.ant.util.*;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.Resource;

import java.io.File;
import java.util.Vector;

/**
 * Essa classe foi criada com o nico propsito de dar suporte  uma 
 * implementao alternativa padro da task <javac>: o comportamento original, 
 * de restringir  compilao apenas s classes desatualizadas,  substituda 
 * aqui; todos os arquivos-fonte do diretrio de origem so compilados nesta 
 * verso.
 * A presenta classe d suporte  classe TecJavac (alterao da Javac).
 * Dois mtodos, alm do construtor, sofreram alterao: restrict e 
 * restrictAsFiles. 
 *
 * @author Leonardo Abreu de Barros $
 * @version 1.0 $  - @date: 2003/07/30 11:43:59 $
 */

public class TecSourceFileScanner implements ResourceFactory {
  protected Task task;
  private FileUtils fileUtils;
  private File destDir;     // base directory of the fileset

  /**
   * Construtor.
   *
   * @param task The task we should log messages through
   */
  public TecSourceFileScanner(Task task) {
    this.task = task;
    fileUtils = FileUtils.getFileUtils();
  }

  /**
   * Esse e o prximo mtodo foram alterados. Ao invs de restringir a lista
   * de arquivos, ele retorna todos os arquivos-fonte.
   *
   * ANTIGA IMPLEMENTAO:
   * Restrict the given set of files to those that are newer than
   * their corresponding target files.
   *
   * @param files   the original set of files
   * @param srcDir  all files are relative to this directory
   * @param destDir target files live here. if null file names
   *                returned by the mapper are assumed to be absolute.
   * @param mapper  knows how to construct a target file names from
   *                source file names.
   *                
   * @return a lista com o nome dos arquivos
   */
  public String[] restrict(String[] files, File srcDir, File destDir,
                           FileNameMapper mapper) {

    // record destdir for later use in getResource
    this.destDir = destDir;
    Vector<Resource> v = new Vector<Resource>();
    for (int i = 0; i < files.length; i++) {
      File src = fileUtils.resolveFile(srcDir, files[i]);
      v.addElement(new Resource(files[i], src.exists(),
                      src.lastModified(), src.isDirectory()));
    }
    Resource[] sourceresources= new Resource[v.size()];
    v.copyInto(sourceresources);

    // Compila todos os arquivos do diretrio com a extenso *.java
    Resource[] coderesources = 
      TecResourceUtils.selectAllSources(task, sourceresources,
                                        mapper, this);
    String[] result = new String[coderesources.length];
    for (int counter=0; counter < coderesources.length; counter++) {
      result[counter] = coderesources[counter].getName();
    }
    return result;
  }

  /**
   * Esse mtodo tambm foi alterado, j que no h mais necessidade do mapper 
   * 
   * ANTIGA IMPLEMENTAO:
   * Convinience layer on top of restrict that returns the source
   * files as File objects (containing absolute paths if srcDir is
   * absolute).
   * 
   * @param files   the original set of files
   * @param srcDir  all files are relative to this directory
   * @param destDir target files live here. if null file names
   *                returned by the mapper are assumed to be absolute.
   * @param mapper  knows how to construct a target file names from
   *                source file names.
   * @return o array com os descritores dos arquivos
   */
  public File[] restrictAsFiles(String[] files, File srcDir, File destDir,
                             FileNameMapper mapper) {
  
    String[] res = restrict(files, srcDir, destDir, mapper);
    File[] result = new File[res.length];
    for (int i = 0; i < res.length; i++) {
      result[i] = new File(srcDir, res[i]);
    }
    return result;
  }

  /**
   * returns resource information for a file at destination
   * @param name relative path of file at destination
   * @return data concerning a file whose relative path to destDir is name
   *
   * @since Ant 1.5.2
   */
  public Resource getResource(String name) {
    File src = fileUtils.resolveFile(destDir, name);
    return new Resource(name, src.exists(), src.lastModified(), 
               src.isDirectory());
  }
}
