/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.ant.input;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputRequest;

public class TextInputHandler
extends DefaultInputHandler {
    protected JDialog dlgInput;
    protected JLabel lblInput;
    protected JTextComponent fldInput;
    protected JButton btnSubmit;

    public void handleInput(InputRequest request) {
        this.build(request);
        this.setEventListeners(request);
        this.dlgInput.pack();
        this.dlgInput.setVisible(true);
    }

    protected void build(InputRequest request) {
        this.lblInput = this.makeLabel(this.getPrompt(request));
        this.fldInput = this.makeTextComponent(request.getInput(), this.lblInput);
        this.btnSubmit = this.makeButton("OK");
        this.dlgInput = this.makeDialog(request.getPrompt());
        this.dlgInput.setModal(true);
    }

    protected JTextComponent makeTextComponent(String text, JLabel label) {
        JTextField field = new JTextField(text);
        field.setPreferredSize(label.getPreferredSize());
        label.setLabelFor(field);
        return field;
    }

    protected JLabel makeLabel(String text) {
        JLabel label = new JLabel(text);
        return label;
    }

    protected JButton makeButton(String text) {
        JButton button = new JButton(text);
        return button;
    }

    protected JDialog makeDialog(String title) {
        JDialog dialog = new JDialog();
        dialog.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        dialog.getContentPane().add((Component)this.lblInput, c);
        c.insets = new Insets(0, 5, 0, 5);
        c.gridy = 1;
        c.fill = 2;
        dialog.getContentPane().add((Component)new JScrollPane(this.fldInput), c);
        c.insets = new Insets(0, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.fill = 0;
        c.anchor = 10;
        dialog.getContentPane().add((Component)this.btnSubmit, c);
        return dialog;
    }

    protected void setEventListeners(final InputRequest request) {
        this.btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextInputHandler.this.commitResult(request);
            }
        });
        this.fldInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TextInputHandler.this.commitResult(request);
                }
            }
        });
    }

    protected void commitResult(InputRequest request) {
        String result = this.fldInput.getText();
        request.setInput(result.length() == 0 ? null : result);
        this.dlgInput.dispose();
    }
}

