/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.ant.taskdefs;

import java.text.MessageFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import tecgraf.javautils.ant.taskdefs.Version;

public class Promote
extends Task {
    private String update;
    private String versionfile;
    private String addproperty;
    private boolean showreleaseversion = false;
    private Version version;

    public void setAddproperty(String addproperty) {
        this.addproperty = addproperty;
    }

    public final void setVersionfile(String versionFile) {
        this.versionfile = versionFile;
    }

    public final void setShowreleaseversion(boolean showreleaseversion) {
        this.showreleaseversion = showreleaseversion;
    }

    public final void setUpdate(String update) {
        this.update = update;
    }

    private void verifyInput() {
        String msgp = "Atributo {0} \u00e9 obrigat\u00f3rio";
        if (this.versionfile == null) {
            this.getProject().fireBuildFinished((Throwable)new BuildException(MessageFormat.format(msgp, "versionfile")));
        }
        if (this.update == null) {
            this.getProject().fireBuildFinished((Throwable)new BuildException(MessageFormat.format(msgp, "update")));
        }
        if (this.addproperty == null) {
            this.getProject().fireBuildFinished((Throwable)new BuildException(MessageFormat.format(msgp, "addproperty")));
        }
    }

    public void execute() throws BuildException {
        String newVersion;
        this.verifyInput();
        this.version = new Version(this.versionfile);
        if (this.update.equals("major-version")) {
            newVersion = this.version.incMajorVersion();
        } else if (this.update.equals("minor-version")) {
            newVersion = this.version.incMinorVersion();
        } else if (this.update.equals("release-version")) {
            newVersion = this.version.incReleaseVersion();
        } else {
            throw new BuildException("Atributo update inv\u00e1lido.");
        }
        InputHandler handler = this.getProject().getInputHandler();
        InputRequest request = new InputRequest("Digite a nova vers\u00e3o [" + newVersion + "]");
        handler.handleInput(request);
        boolean valid = true;
        if (!request.getInput().equals("")) {
            valid = this.version.parse(request.getInput());
        }
        if (valid) {
            this.getProject().setProperty(this.addproperty, this.version.getFormattedVersion(this.showreleaseversion));
            this.version.updateProperties();
        } else {
            this.getProject().setProperty(this.addproperty, request.getInput());
        }
    }
}

