/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.ant.taskdefs;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import tecgraf.javautils.ant.taskdefs.TecResourceUtils;

public class TecSourceFileScanner
implements ResourceFactory {
    protected Task task;
    private FileUtils fileUtils;
    private File destDir;

    public TecSourceFileScanner(Task task) {
        this.task = task;
        this.fileUtils = FileUtils.getFileUtils();
    }

    public String[] restrict(String[] files, File srcDir, File destDir, FileNameMapper mapper) {
        this.destDir = destDir;
        Vector<Resource> v = new Vector<Resource>();
        for (int i = 0; i < files.length; ++i) {
            File src = this.fileUtils.resolveFile(srcDir, files[i]);
            v.addElement(new Resource(files[i], src.exists(), src.lastModified(), src.isDirectory()));
        }
        Object[] sourceresources = new Resource[v.size()];
        v.copyInto(sourceresources);
        Resource[] coderesources = TecResourceUtils.selectAllSources((ProjectComponent)this.task, (Resource[])sourceresources, mapper, this);
        String[] result = new String[coderesources.length];
        for (int counter = 0; counter < coderesources.length; ++counter) {
            result[counter] = coderesources[counter].getName();
        }
        return result;
    }

    public File[] restrictAsFiles(String[] files, File srcDir, File destDir, FileNameMapper mapper) {
        String[] res = this.restrict(files, srcDir, destDir, mapper);
        File[] result = new File[res.length];
        for (int i = 0; i < res.length; ++i) {
            result[i] = new File(srcDir, res[i]);
        }
        return result;
    }

    public Resource getResource(String name) {
        File src = this.fileUtils.resolveFile(this.destDir, name);
        return new Resource(name, src.exists(), src.lastModified(), src.isDirectory());
    }
}

