/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class Version {
    private static final String VERSIONDATE_KEY = "version-date";
    private static final String RELEASEDATE_KEY = "release-date";
    private static final String MAJORVERSION_KEY = "major-version";
    private static final String MINORVERSION_KEY = "minor-version";
    private static final String RELEASEVERSION_KEY = "release-version";
    private static final String FORMAT_KEY = "format";
    private static final String DATEFORMAT_KEY = "date-format";
    private static final String SEPARATOR_KEY = "separator";
    private Date versionDate;
    private Date releaseDate;
    private String majorVersion;
    private String minorVersion;
    private String releaseVersion;
    private String format;
    private String dateFormat;
    private String separator;
    private String filePath;
    private Properties properties = new Properties();

    public Version(String versionPropertiesFile) throws BuildException {
        try {
            this.loadVersionProperties(versionPropertiesFile);
            this.dateFormat = this.properties.getProperty(DATEFORMAT_KEY).trim();
            SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
            this.versionDate = sdf.parse(this.properties.getProperty(VERSIONDATE_KEY).trim());
            this.releaseDate = sdf.parse(this.properties.getProperty(RELEASEDATE_KEY).trim());
            this.majorVersion = this.properties.getProperty(MAJORVERSION_KEY).trim();
            this.minorVersion = this.properties.getProperty(MINORVERSION_KEY).trim();
            this.releaseVersion = this.properties.getProperty(RELEASEVERSION_KEY).trim();
            this.format = this.properties.getProperty(FORMAT_KEY).trim();
            this.separator = this.properties.getProperty(SEPARATOR_KEY).trim();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        if (!this.validate()) {
            throw new BuildException("Formato inv\u00e1lido");
        }
    }

    private void loadVersionProperties(String filePath) throws IOException {
        this.filePath = filePath;
        FileInputStream is = new FileInputStream(new File(filePath));
        this.properties.load(is);
        ((InputStream)is).close();
    }

    public String getCurrentVersion() {
        return this.majorVersion + "." + this.minorVersion;
    }

    public String getCurrentRelease() {
        return this.majorVersion + "." + this.minorVersion + "." + this.releaseVersion;
    }

    public void updateProperties() throws BuildException {
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
        this.properties.put(VERSIONDATE_KEY, sdf.format(this.versionDate));
        this.properties.put(RELEASEDATE_KEY, sdf.format(this.releaseDate));
        this.properties.put(MAJORVERSION_KEY, this.majorVersion);
        this.properties.put(MINORVERSION_KEY, this.minorVersion);
        this.properties.put(RELEASEVERSION_KEY, this.releaseVersion);
        try {
            FileOutputStream os = new FileOutputStream(new File(this.filePath));
            this.properties.store(os, "");
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public String incMajorVersion() {
        this.versionDate = new Date();
        this.releaseDate = new Date();
        this.majorVersion = Integer.toString(Integer.parseInt(this.majorVersion) + 1);
        this.minorVersion = "0";
        this.releaseVersion = "0";
        return this.getCurrentVersion();
    }

    public String incMinorVersion() {
        this.versionDate = new Date();
        this.releaseDate = new Date();
        this.minorVersion = Integer.toString(Integer.parseInt(this.minorVersion) + 1);
        this.releaseVersion = "0";
        return this.getCurrentVersion();
    }

    public String incReleaseVersion() {
        this.releaseDate = new Date();
        this.releaseVersion = Integer.toString(Integer.parseInt(this.releaseVersion) + 1);
        return this.getCurrentRelease();
    }

    private String format(boolean showReleaseVersion) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
        String v = this.format;
        v = v.replace("<VERSIONDATE>", sdf.format(this.versionDate));
        v = v.replace("<MAJORVERSION>", this.majorVersion);
        v = v.replace("<MINORVERSION>", this.minorVersion);
        if (!this.releaseVersion.equals("-1") && showReleaseVersion) {
            v = v.replace("<RELEASEVERSION>", this.releaseVersion);
        } else {
            v = v.replace(this.separator + "<RELEASEVERSION>", "");
            v = v.replace("<RELEASEVERSION>" + this.separator, "");
            v = v.replace(this.separator + "<RELEASEVERSION>" + this.separator, "");
        }
        return v;
    }

    public String getFormattedVersion(boolean showReleaseVersion) {
        return this.format(showReleaseVersion);
    }

    public boolean parse(String newVersion) {
        boolean r;
        String[] a = newVersion.split("\\.");
        try {
            this.majorVersion = a[0];
            this.minorVersion = a[1];
            this.releaseVersion = a.length == 3 ? a[2] : "-1";
            r = this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
            r = false;
        }
        return r;
    }

    private boolean validate() {
        boolean valid = true;
        try {
            Integer.parseInt(this.majorVersion);
            Integer.parseInt(this.minorVersion);
            Integer.parseInt(this.releaseVersion);
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid;
    }
}

