package tecgraf.javautils.concurrent.locks;

import java.util.ArrayList;
import java.util.List;

/**
 * Classe de dependncia dos objetos
 * 
 * @param <T> o tipo do objeto alvo (target)
 * @param <S> o tipo do objeto do qual o target  dependente
 * 
 * @author Tecgraf
 */
public abstract class LockDependency<T extends SharedAccessObject, S extends SharedAccessObject> {

  /**
   * Poltica esperada para as dependncias
   */
  private LockPolicy policy;

  /**
   * Dependncia da dependncia
   */
  private List<LockDependency<S, ?>> chain;

  /**
   * Construtor
   * 
   * @param policy
   */
  public LockDependency(LockPolicy policy) {
    this.policy = policy;
  }

  /**
   * Recupera poltica de lock
   * 
   * @return poltica de lock
   */
  public LockPolicy getPolicy() {
    return this.policy;
  }

  /**
   * Recupera cadeia de dependncia
   * 
   * @return a cadeia de dependncia
   */
  public LockDependency<SharedAccessObject, SharedAccessObject>[] getChain() {
    if (this.chain != null) {
      return this.chain.toArray(new LockDependency[0]);
    }
    return null;
  }

  /**
   * Adiciona  cadeia de dependncia
   * 
   * @param chainDependency cadeia de dependncia
   */
  public void addChain(LockDependency<S, ?> chainDependency) {
    if (this.chain == null) {
      this.chain = new ArrayList<LockDependency<S, ?>>();
    }
    this.chain.add(chainDependency);
  }

  /**
   * Recupera os objetos dependentes
   * 
   * @param <E> tipo do objeto alvo
   * 
   * @param target o objeto alvo do lock
   * @return os objetos dependentes
   */
  public abstract <E extends T> S[] getDependency(E target);
}