package tecgraf.javautils.concurrent.locks.exceptions;

/**
 * Exceo para distinguir uma falha na tentativa de liberar um lock sobre um
 * objeto que no tem locks relacionados
 */
public class ObjectNotLockedException extends RuntimeException {

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param clientMessage a descrio do erro
   */
  public ObjectNotLockedException(String clientMessage) {
    super(clientMessage);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   * 
   * @param clientMessage a descrio do erro
   * @param exception a exceo original
   */
  public ObjectNotLockedException(String clientMessage, Throwable exception) {
    super(clientMessage, exception);
  }
}
