package tecgraf.javautils.excel.v1;

import java.awt.Component;

/**
 * Exporta o componente grfico. Essa interface  usado pela API Excel
 * localizado no pacote logistic.client.util.excel para exportar um componente
 * externa ao framework.<br/>
 * <br/>
 * Assim, toda vez que for criado um componente novo e que deseja exportar para
 * excel, o componente dever implementar essa interface para que o framework
 * Excel possa fazer conforme o algortmo implementado.<br/>
 * <br/>
 * O algoritmo de exportao deve considerar a linha e coluna j atribuida pelo
 * framework Excel que determina a localizao da exportao desse componente.
 * Assim, previamente ser atribuido uma linha e uma coluna antes de ser
 * executado o algoritmo de exportao desse componente.  de responsabilidade
 * do algoritimo desse componente considerar a linha e a coluna j atribuida.
 * 
 * @author Tecgraf
 */
public interface ExcelExportableAdapter {

  /**
   * Exporta o componente
   * 
   * @param component componente a ser exportado
   * @param head ferramenta da estrutura da planilha
   * @param data ferramenta de contedo da planilha
   * @param style ferramenta de estilo da planilha
   * @param format formatador de conteudo da tabela
   */
  public void exportExcel(Component component, ExcelStructureTool head,
    ExcelDataTool data, ExcelStyleTool style, ExcelTable format);

  /**
   * Indica quantas linhas sero necessrias para exportar o componente
   * 
   * @param component componente a ser exportado
   * @return quantidade de linhas
   */
  public int getRowCount(Component component);

  /**
   * Indica quantas colunas sero necessrias para exportar o componente
   * 
   * @param component componente a ser exportado
   * @return quantidade de colunas
   */
  public int getColumnCount(Component component);

}
