package tecgraf.javautils.excel.v1;

/**
 * Classe que representa um estilo
 * 
 * 
 * @author bbreder
 */
public interface ExcelStyle {

  /**
   * Aplica o alinhamento para esquerda
   * 
   * @return prpria estrutura
   */
  public ExcelStyle left();

  /**
   * Aplica o alinhamento para o centro
   * 
   * @return prpria estrutura
   */
  public ExcelStyle center();

  /**
   * Aplica o alinhamento para direita
   * 
   * @return prpria estrutura
   */
  public ExcelStyle right();

  /**
   * Aplica negrito no estilo
   * 
   * @return prpria estrutura
   */
  public ExcelStyle bold();

  /**
   * Aplica italico no estilo
   * 
   * @return prpria estrutura
   */
  public ExcelStyle italic();

  /**
   * Aplica sobrelinha no estilo
   * 
   * @return prpria estrutura
   */
  public ExcelStyle strikeout();

  /**
   * Aplica uma cor para o texto no estilo
   * 
   * @param color cor do texto
   * @return prpria estrutura
   */
  public ExcelStyle forecolor(ExcelColor color);

  /**
   * Aplica um fundo para o estilo
   * 
   * @param color cor do fundo
   * @return prpria estrutura
   */
  public ExcelStyle backcolor(ExcelColor color);

  /**
   * Aplica um tamanho de fonte diferente para o estilo
   * 
   * @param height altura em pixel
   * @return prpria estrutura
   */
  public ExcelStyle size(int height);

  /**
   * Aplica a borda no topo
   * 
   * @param stroke espessura da linha
   * @param color cor da linha
   * @return prpria estrutura
   */
  public ExcelStyle borderTop(ExcelStroke stroke, ExcelColor color);

  /**
   * Aplica a borda em baixo
   * 
   * @param stroke espessura da linha
   * @param color cor da linha
   * @return prpria estrutura
   */
  public ExcelStyle borderBottom(ExcelStroke stroke, ExcelColor color);

  /**
   * Aplica a borda
   * 
   * @param stroke espessura da linha
   * @param color cor da linha
   * @return prpria estrutura
   */
  public ExcelStyle borderLeft(ExcelStroke stroke, ExcelColor color);

  /**
   * Aplica a borda
   * 
   * @param stroke espessura da linha
   * @param color cor da linha
   * @return prpria estrutura
   */
  public ExcelStyle borderRight(ExcelStroke stroke, ExcelColor color);

  /**
   * Retorna o objeto de implementao
   * 
   * @return objeto de implementao
   */
  public Object getAdapter();

}
