package tecgraf.javautils.excel.v1.poi;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import tecgraf.javautils.excel.v1.Excel;
import tecgraf.javautils.excel.v1.ExcelDataTool;
import tecgraf.javautils.excel.v1.ExcelFactory;
import tecgraf.javautils.excel.v1.ExcelModel;
import tecgraf.javautils.excel.v1.ExcelSheet;
import tecgraf.javautils.excel.v1.ExcelStructureTool;
import tecgraf.javautils.excel.v1.ExcelStyle;

/**
 * Classe que inicializa objetos do tipo Poi
 * 
 * 
 * @author bbreder
 */
public class PoiExcelFactory implements ExcelFactory {

  /** Instancia nica */
  private static final PoiExcelFactory instance = new PoiExcelFactory();

  /**
   * Construtor padro
   */
  private PoiExcelFactory() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PoiExcel buildExcel(ExcelModel... models) {
    return new PoiExcel(models);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExcelSheet buildExcelSheet(Excel adapter) {
    return new PoiExcelSheet((PoiExcel) adapter);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExcelDataTool buildExcelData(ExcelSheet adapter) {
    PoiExcelSheet sheet = (PoiExcelSheet) adapter;
    return new PoiExcelDataTool(sheet);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExcelStructureTool buildExcelHeadFormat(ExcelSheet adapter) {
    PoiExcelSheet sheet = (PoiExcelSheet) adapter;
    return new PoiExcelStructureTool(sheet);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExcelStyle buildExcelStyle(Excel adapter) {
    HSSFWorkbook workbook = (HSSFWorkbook) adapter.getAdapter();
    return new PoiExcelStyle(workbook);
  }

  /**
   * Retorna a instancia unica
   * 
   * @return instancia unica
   */
  public static PoiExcelFactory getInstance() {
    return instance;
  }

}
