package tecgraf.javautils.excel.v1.poi;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import tecgraf.javautils.excel.v1.ExcelTool;

/**
 * Classe responsvel por armazenar campos percentence a uma etapa da gerao de
 * uma planilha.
 * 
 * 
 * @author bbreder
 */
public abstract class PoiExcelTool implements ExcelTool {

  /** Referencia para o ajudante do sheet */
  private final PoiExcelSheet helper;
  /** Referencia para a planilha Excel */
  private final HSSFWorkbook workbook;
  /** Referencia para o sheet */
  private HSSFSheet sheet;

  /**
   * Construtor padro
   * 
   * @param workbook
   * @param helper
   */
  public PoiExcelTool(HSSFWorkbook workbook, PoiExcelSheet helper) {
    this.workbook = workbook;
    this.helper = helper;
  }

  /**
   * Retorna a referencia da planilha excel.
   * 
   * @return planilha excel
   */
  public HSSFWorkbook getWorkbook() {
    return workbook;
  }

  /**
   * Retorna o sheet na qual est trabalhando
   * 
   * @return sheet
   */
  public HSSFSheet getPoiSheet() {
    return sheet;
  }

  /**
   * Altera o sheet em que est trabalhando
   * 
   * @param sheet
   */
  public void setSheet(HSSFSheet sheet) {
    this.sheet = sheet;
  }

  /**
   * Retorna a planilha Poi
   * 
   * @return planilha
   */
  @Override
  public PoiExcelSheet getSheet() {
    return helper;
  }

}