/*
 * $Id: XLSFilter.java 74496 2008-04-03 16:35:07Z allan $
 */
package tecgraf.javautils.excel.v1.util;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * Filtro que aceita arquivos cuja extenso seja xls.
 */
public class ExcelFilter extends FileFilter {

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean accept(File file) {
    String filename = file.getName();
    if (file.isDirectory())
      return true;
    return filename.endsWith(".xls");
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getDescription() {
    return "*.xls";
  }
}