/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v1.poi;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import tecgraf.javautils.excel.v1.Excel;
import tecgraf.javautils.excel.v1.ExcelFactory;
import tecgraf.javautils.excel.v1.ExcelModel;
import tecgraf.javautils.excel.v1.poi.PoiExcelFactory;
import tecgraf.javautils.excel.v1.poi.PoiExcelSheet;

public class PoiExcel
implements Excel {
    private HSSFWorkbook workbook;
    private ExcelModel[] models;
    private ExcelFactory factory = PoiExcelFactory.getInstance();

    public PoiExcel(ExcelModel ... models) {
        this.models = models;
    }

    public void save(OutputStream output) throws IOException {
        this.workbook = new HSSFWorkbook();
        PoiExcelSheet sheetHelper = new PoiExcelSheet(this);
        for (ExcelModel model : this.models) {
            String sheetname = model.getSheetName();
            HSSFSheet sheet = this.workbook.createSheet(sheetname);
            sheetHelper.build(model, this.workbook, sheet);
        }
        this.workbook.write(output);
        output.close();
    }

    @Override
    public ExcelModel[] getModels() {
        return this.models;
    }

    protected HSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public Object getAdapter() {
        return this.getWorkbook();
    }

    @Override
    public ExcelFactory getFactory() {
        return this.factory;
    }
}

