/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v1.poi;

import org.apache.poi.ss.util.CellRangeAddress;
import tecgraf.javautils.excel.v1.ExcelMerge;
import tecgraf.javautils.excel.v1.ExcelStructureTool;
import tecgraf.javautils.excel.v1.poi.PoiExcelSheet;
import tecgraf.javautils.excel.v1.poi.PoiExcelTool;
import tecgraf.javautils.excel.v1.util.DefaultExcelMerge;

public class PoiExcelStructureTool
extends PoiExcelTool
implements ExcelStructureTool {
    private static final int EXCEL_UNIT_TO_PIXEL = 42;
    private final PoiExcelSheet helper;
    private int columnBegin;
    private int columnEnd;
    private int rowBegin;
    private int rowEnd;

    public PoiExcelStructureTool(PoiExcelSheet helper) {
        super(helper.getExcel().getWorkbook(), helper);
        this.helper = helper;
        this.columnBegin = 1;
        this.columnEnd = 1;
        this.rowBegin = 1;
        this.rowEnd = 1;
    }

    @Override
    public PoiExcelStructureTool merge(int columnBegin, int columnEnd, int rowBegin, int rowEnd) {
        this.columnBegin = columnBegin;
        this.columnEnd = columnEnd;
        this.rowBegin = rowBegin;
        this.rowEnd = rowEnd;
        this.getPoiSheet().addMergedRegion(new CellRangeAddress(rowBegin - 1, rowEnd - 1, columnBegin - 1, columnEnd - 1));
        return this;
    }

    @Override
    public ExcelMerge hasMerge(int columnIndex, int rowIndex) {
        short colIndex = (short)(columnIndex - 1);
        for (int n = 0; n < this.getPoiSheet().getNumMergedRegions(); ++n) {
            CellRangeAddress region = this.getPoiSheet().getMergedRegion(n);
            if (!region.isInRange(rowIndex - 1, (int)colIndex)) continue;
            return new DefaultExcelMerge(region.getFirstColumn() + 1, region.getLastColumn() + 1, region.getFirstRow() + 1, region.getLastRow() + 1);
        }
        return null;
    }

    @Override
    public PoiExcelStructureTool mergeRow(int column, int rowBegin, int rowEnd) {
        return this.merge(column, column, rowBegin, rowEnd);
    }

    @Override
    public PoiExcelStructureTool mergeColumn(int columnBegin, int columnEnd, int row) {
        return this.merge(columnBegin, columnEnd, row, row);
    }

    @Override
    public PoiExcelStructureTool repeatLineMerge(int ... columns) {
        if (this.rowBegin < 1 || this.rowEnd < 1 || this.rowBegin > Short.MAX_VALUE || this.rowEnd > Short.MAX_VALUE) {
            throw new IllegalStateException();
        }
        for (int column : columns) {
            this.mergeRow(column, this.rowBegin, this.rowEnd);
        }
        return this;
    }

    @Override
    public PoiExcelStructureTool repeatColumnMerge(int ... rows) {
        if (this.columnBegin < 1 || this.columnEnd < 1 || this.columnBegin > Short.MAX_VALUE || this.columnEnd > Short.MAX_VALUE) {
            throw new IllegalStateException();
        }
        for (int row : rows) {
            this.mergeColumn(this.columnBegin, this.columnEnd, row);
        }
        return this;
    }

    @Override
    public ExcelStructureTool setColumnWidth(int column, int width) {
        this.columnBegin = column;
        this.columnEnd = column;
        width = Math.min(width * 42, Short.MAX_VALUE);
        this.getPoiSheet().setColumnWidth(column - 1, width);
        return this;
    }

    @Override
    public int getColumnWidth(int column) {
        return this.getPoiSheet().getColumnWidth(column - 1) / 42;
    }

    @Override
    public ExcelStructureTool setRowHeight(int row, int height) {
        this.rowBegin = row;
        this.rowEnd = row;
        return this;
    }

    @Override
    public PoiExcelSheet getHelper() {
        return this.helper;
    }

    @Override
    public void setColumn(int columnBegin, int columnEnd) {
        this.setColumnBegin(columnBegin);
        this.setColumnEnd(columnEnd);
    }

    @Override
    public void setRow(int rowBegin, int rowEnd) {
        this.setRowBegin(rowBegin);
        this.setRowEnd(rowEnd);
    }

    @Override
    public int getColumnBegin() {
        return this.columnBegin;
    }

    @Override
    public void setColumnBegin(int columnBegin) {
        if (columnBegin < 1 || columnBegin > Short.MAX_VALUE) {
            throw new IllegalArgumentException("" + columnBegin);
        }
        this.columnBegin = columnBegin;
    }

    @Override
    public int getColumnEnd() {
        return this.columnEnd;
    }

    @Override
    public void setColumnEnd(int columnEnd) {
        if (columnEnd < 1 || columnEnd > Short.MAX_VALUE) {
            throw new IllegalArgumentException("" + columnEnd);
        }
        this.columnEnd = columnEnd;
    }

    @Override
    public int getRowBegin() {
        return this.rowBegin;
    }

    @Override
    public void setRowBegin(int rowBegin) {
        this.rowBegin = rowBegin;
    }

    @Override
    public int getRowEnd() {
        return this.rowEnd;
    }

    @Override
    public void setRowEnd(int rowEnd) {
        this.rowEnd = rowEnd;
    }

    public String toString() {
        return "PoiExcelStructureTool [columnBegin=" + this.columnBegin + ", columnEnd=" + this.columnEnd + ", rowBegin=" + this.rowBegin + ", rowEnd=" + this.rowEnd + "]";
    }
}

