/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v1.util;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tecgraf.javautils.excel.v1.ExcelColor;
import tecgraf.javautils.excel.v1.ExcelConfig;
import tecgraf.javautils.excel.v1.ExcelDataTool;
import tecgraf.javautils.excel.v1.ExcelExportable;
import tecgraf.javautils.excel.v1.ExcelExportableAdapter;
import tecgraf.javautils.excel.v1.ExcelStroke;
import tecgraf.javautils.excel.v1.ExcelStructureTool;
import tecgraf.javautils.excel.v1.ExcelStyle;
import tecgraf.javautils.excel.v1.ExcelStyleTool;
import tecgraf.javautils.excel.v1.ExcelTable;
import tecgraf.javautils.excel.v1.style.DefaultExcelStyleSet;

public abstract class ExcelTableUtil {
    public static void setTable(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, int column, int row, JTable table) {
        ExcelTableUtil.setTable(head, data, style, column, row, table, null);
    }

    public static void setTable(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, int column, int row, JTable table, ExcelTable format) {
        ExcelTableUtil.setTable(head, data, style, column, row, table, format, false);
    }

    public static void setTable(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, int column, int row, JTable table, ExcelTable format, boolean firstIsRowHeader) {
        if (format == null) {
            throw new IllegalArgumentException("formatador de tabela \u00e9 nulo");
        }
        data.setCell(column, row);
        TableModel model = table.getModel();
        JScrollPane scroll = ExcelTableUtil.getScroll(table);
        if (scroll instanceof ExcelExportable) {
            ExcelExportable excelExportable = (ExcelExportable)((Object)scroll);
            excelExportable.exportExcel(head, data, style, format);
        } else {
            Point dataPoint = ExcelTableUtil.getDataPoint(table, head, data, style);
            int dataRow = row + dataPoint.y;
            int dataColumn = column + dataPoint.x;
            if (scroll != null) {
                ExcelTableUtil.showCorner(head, data, style, table, row, column, dataRow, dataColumn, format);
                ExcelTableUtil.showAdvanceColumnHeader(head, data, style, table, row, column, dataRow, dataColumn, format);
                ExcelTableUtil.showRowHeader(head, data, style, table, dataRow, column, format);
            } else {
                ExcelTableUtil.showBasicColumnHeader(head, data, style, table, dataRow, dataColumn, format);
            }
            ExcelTableUtil.exportData(data, style, table, format, firstIsRowHeader, dataRow, dataColumn);
            if (firstIsRowHeader) {
                style.addBoxRow(dataColumn, dataRow, dataRow + model.getRowCount() - 1, ExcelStroke.MEDIUM, ExcelColor.BLACK);
            }
            if (model.getRowCount() > 0) {
                data.decColumn();
            }
            style.addBox(column, data.getColumn(), row, data.getRow(), ExcelStroke.MEDIUM, ExcelColor.BLACK);
            data.incRow();
            data.setColumn(column);
        }
    }

    public static void exportData(ExcelDataTool data, ExcelStyleTool style, JTable table, ExcelTable format, boolean firstIsRowHeader, int dataRow, int dataColumn) {
        for (int r = 0; r < table.getRowCount(); ++r) {
            data.setCell(dataColumn, dataRow + r);
            for (int c = 0; c < table.getColumnCount(); ++c) {
                Object valueAt = table.getValueAt(r, c);
                if (firstIsRowHeader && c == 0) {
                    style.setStyle(dataColumn, dataRow + r, DefaultExcelStyleSet.buildRowHeader(style));
                }
                if (format != null) {
                    valueAt = format.getValue(table, r, c, valueAt);
                    ExcelStyle cellStyle = format.getStyle(table, r, c, style);
                    if (cellStyle != null) {
                        style.setStyle(dataColumn + c, dataRow + r, cellStyle);
                    }
                } else {
                    valueAt = ExcelTableUtil.fixTableValue(table, r, c, valueAt);
                }
                data.setCellHorizontal(valueAt);
            }
        }
    }

    private static Object fixTableValue(JTable table, int row, int column, Object value) {
        Component comp = table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, false, false, row, column);
        if (comp instanceof JLabel) {
            value = ((JLabel)comp).getText();
        }
        return value;
    }

    public static void showRowHeader(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, JTable table, int row, int column, ExcelTable format) {
        Component rowHeader;
        JScrollPane scroll = ExcelTableUtil.getScroll(table);
        Component corner = ExcelTableUtil.getCorner(scroll);
        data.setCell(column, row);
        if (corner != null) {
            data.incRow();
        }
        boolean hasRowHeader = scroll.getRowHeader() != null && scroll.getRowHeader().getView() != null;
        Component component = rowHeader = hasRowHeader ? scroll.getRowHeader().getView() : null;
        if (hasRowHeader) {
            JTree tree;
            TreeModel rowModel;
            if (JList.class.isInstance(rowHeader)) {
                JList list = (JList)rowHeader;
                ListModel rowModel2 = list.getModel();
                for (int r = 0; r < rowModel2.getSize(); ++r) {
                    Object valueAt = rowModel2.getElementAt(r);
                    ExcelStyle cellStyle = null;
                    if (format != null) {
                        valueAt = format.getRowHeaderValue(table, r, valueAt);
                        cellStyle = format.getRowHeaderStyle(table, row + r, style);
                    }
                    if (cellStyle == null) {
                        cellStyle = DefaultExcelStyleSet.buildRowHeader(style);
                    }
                    style.setStyle(data.getColumn(), data.getRow(), cellStyle);
                    data.setCellVertical(valueAt);
                }
                style.addBox(column, column, row, row + rowModel2.getSize() - 1, ExcelStroke.MEDIUM, ExcelColor.BLACK);
            } else if (JTree.class.isInstance(rowHeader) && TreeNode.class.isInstance((rowModel = (tree = (JTree)rowHeader).getModel()).getRoot())) {
                TreeNode node = (TreeNode)rowModel.getRoot();
                ExcelTableUtil.setTable(head, data, style, table, tree, node, 0, format);
                style.addBox(column, column, row, data.getRow() - 1, ExcelStroke.MEDIUM, ExcelColor.BLACK);
                style.addBox(column, column + table.getColumnCount(), row + 1, data.getRow() - 1, ExcelStroke.MEDIUM, ExcelColor.BLACK);
            }
        }
    }

    private static void showAdvanceColumnHeader(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, JTable table, int row, int column, int dataRow, int dataColumn, ExcelTable format) {
        JScrollPane scroll = ExcelTableUtil.getScroll(table);
        Component columnHeader = scroll.getColumnHeader() != null ? scroll.getColumnHeader().getView() : null;
        ExcelExportableAdapter exportableAdapter = ExcelConfig.getExportable(columnHeader);
        if (columnHeader instanceof ExcelExportable) {
            ExcelExportable excelExportable = (ExcelExportable)((Object)columnHeader);
            data.setCell(column, row);
            excelExportable.exportExcel(head, data, style, format);
        } else if (exportableAdapter != null) {
            data.setCell(column, row);
            exportableAdapter.exportExcel(columnHeader, head, data, style, format);
        } else {
            ExcelTableUtil.showBasicColumnHeader(head, data, style, table, row, dataColumn, format);
        }
    }

    private static void showBasicColumnHeader(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, JTable table, int row, int column, ExcelTable format) {
        TableModel model = table.getModel();
        data.setCell(column, row);
        for (int c = 0; c < model.getColumnCount(); ++c) {
            String valueAt = model.getColumnName(c).replace("\n", " ");
            if (format != null) {
                valueAt = format.getColumnHeaderValue(table, c, valueAt).toString();
                ExcelStyle cellStyle = format.getColumnHeaderStyle(table, column + c, style);
                if (cellStyle != null) {
                    style.setStyle(column + c, row, cellStyle);
                } else {
                    style.setStyle(column + c, row, DefaultExcelStyleSet.buildColumnHeader(style));
                }
            } else {
                style.setStyle(column + c, row, DefaultExcelStyleSet.buildColumnHeader(style));
            }
            data.setCell(column + c, row, valueAt);
        }
        style.addBoxColumn(column, column + model.getColumnCount() - 1, row, ExcelStroke.MEDIUM, ExcelColor.BLACK);
    }

    private static Point getDataPoint(JTable table, ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style) {
        int headerRow = 0;
        int headerColumn = 0;
        JScrollPane scroll = ExcelTableUtil.getScroll(table);
        if (scroll == null && table.getColumnCount() > 0) {
            headerRow = 1;
        } else {
            boolean hasRowHeader = scroll.getRowHeader() != null && scroll.getRowHeader().getView() != null;
            Component rowHeader = hasRowHeader ? scroll.getRowHeader().getView() : null;
            boolean hasColumnHeader = scroll.getColumnHeader() != null && scroll.getColumnHeader().getView() != null;
            Component columnHeader = scroll.getColumnHeader().getView();
            if (scroll != null) {
                headerRow = 1;
                if (ExcelTableUtil.hasCorner(scroll)) {
                    headerColumn = 1;
                    headerRow = 1;
                }
                if (hasRowHeader) {
                    if (JList.class.isInstance(rowHeader)) {
                        headerColumn = 1;
                    } else if (JTree.class.isInstance(rowHeader)) {
                        headerColumn = 1;
                    }
                }
                if (!hasColumnHeader) {
                    headerRow = 1;
                }
            }
        }
        return new Point(headerColumn, headerRow);
    }

    private static void showCorner(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, JTable table, int row, int column, int dataRow, int dataColumn, ExcelTable format) {
        Object value;
        JScrollPane scroll = ExcelTableUtil.getScroll(table);
        Component corner = scroll.getCorner("UPPER_LEFT_CORNER");
        style.setStyle(column, row, DefaultExcelStyleSet.buildColumnHeader(style));
        style.addBox(column, row, ExcelStroke.MEDIUM, ExcelColor.BLACK);
        if (corner != null && format != null && (value = format.getCorner(corner)) != null) {
            data.setCell(column, row, value.toString());
        }
        if (dataRow - row > 1 || dataColumn - column > 1) {
            head.merge(column, dataColumn, row, dataRow - 1);
        }
    }

    private static boolean hasCorner(JScrollPane scroll) {
        Component corner = scroll.getCorner("UPPER_LEFT_CORNER");
        return corner != null;
    }

    private static void setTable(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, JTable table, JTree tree, TreeNode node, int deep, ExcelTable format) {
        for (int r = 0; r < node.getChildCount(); ++r) {
            TreeNode child = node.getChildAt(r);
            String text = child.toString().replace('\n', ' ');
            if (format != null) {
                text = format.getRowHeaderValue(table, r, text).toString();
            }
            for (int n = 0; n < deep; ++n) {
                text = "     " + text;
            }
            data.setCellVertical(text);
            int row = data.getRow() - 1;
            style.setStyle(data.getColumn(), row, DefaultExcelStyleSet.buildRowHeader(style));
            if (format != null) {
                ExcelStyle cellStyle = format.getRowHeaderStyle(table, row, style);
                if (cellStyle != null) {
                    style.setStyle(data.getColumn(), row, cellStyle);
                } else {
                    style.setStyle(data.getColumn(), row, DefaultExcelStyleSet.buildRowHeader(style));
                }
            } else {
                style.setStyle(data.getColumn(), row, DefaultExcelStyleSet.buildRowHeader(style));
            }
            TreePath path = ExcelTableUtil.buildTreePath(child);
            if (child.getChildCount() <= 0 || !tree.isExpanded(path) || deep >= data.getMaxRowDeep()) continue;
            data.incColumn();
            data.decColumn();
            ExcelTableUtil.setTable(head, data, style, table, tree, child, deep + 1, format);
        }
    }

    private static TreePath buildTreePath(TreeNode child) {
        if (child.getParent() != null) {
            TreePath parent = ExcelTableUtil.buildTreePath(child.getParent());
            int size = parent.getPath().length;
            Object[] paths = new Object[size + 1];
            System.arraycopy(parent.getPath(), 0, paths, 0, size);
            paths[size] = child;
            return new TreePath(paths);
        }
        return new TreePath(child);
    }

    private static int getTreeNodeDeep(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, JTree tree, TreeNode node) {
        int count = 1;
        for (int r = 0; r < node.getChildCount(); ++r) {
            TreeNode child = node.getChildAt(r);
            TreePath path = ExcelTableUtil.buildTreePath(child);
            if (child.getChildCount() <= 0 || !tree.isExpanded(path)) continue;
            count = ExcelTableUtil.getTreeNodeDeep(head, data, style, tree, child) + 1;
        }
        return Math.min(count, data.getMaxRowDeep());
    }

    private static JScrollPane getScroll(JTable table) {
        if (table.getParent() != null && JViewport.class.isInstance(table.getParent()) && table.getParent().getParent() != null && JScrollPane.class.isInstance(table.getParent().getParent())) {
            return (JScrollPane)table.getParent().getParent();
        }
        return null;
    }

    public static Component getCorner(JScrollPane scroll) {
        return scroll.getCorner("UPPER_LEFT_CORNER");
    }
}

