/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v2;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import tecgraf.javautils.excel.v1.util.XmlNode;

public class TecExcel {
    private int tabSequence = 1;
    private final XmlNode document = new XmlNode("excel");
    private XmlNode tab = new XmlNode("tab").setAttribute("name", "").setAttribute("order", TecExcel.toString(this.tabSequence++));

    public TecExcel() {
        this.document.addNode(this.tab);
    }

    public TecExcel setCell(int row, int column, String text) {
        if (row < 0 || column < 0 || text == null) {
            return this;
        }
        this.removeRectIntersects(row, column, "cell");
        this.removeCellEqual(row, column, "cell");
        this.tab.addNode(new XmlNode("cell").setAttribute("row", TecExcel.toString(row)).setAttribute("col", TecExcel.toString(column)).setAttribute("text", text));
        return this;
    }

    public TecExcel setBackColor(int row, int column, Color color) {
        if (row < 0 || column < 0 || color == null) {
            return this;
        }
        this.removeRectIntersects(row, column, "backcolor");
        this.removeCellEqual(row, column, "backcolor");
        this.tab.addNode(new XmlNode("backcolor").setAttribute("row", TecExcel.toString(row)).setAttribute("col", TecExcel.toString(column)).setAttribute("color", TecExcel.toString(color)));
        return this;
    }

    public TecExcel setForeColor(int row, int column, Color color) {
        if (row < 0 || column < 0 || color == null) {
            return this;
        }
        this.removeRectIntersects(row, column, "forecolor");
        this.removeCellEqual(row, column, "forecolor");
        this.tab.addNode(new XmlNode("forecolor").setAttribute("row", TecExcel.toString(row)).setAttribute("col", TecExcel.toString(column)).setAttribute("color", TecExcel.toString(color)));
        return this;
    }

    public TecExcel setFont(int row, int column, Font font) {
        if (row < 0 || column < 0 || font == null) {
            return this;
        }
        this.removeRectIntersects(row, column, "font");
        this.removeCellEqual(row, column, "font");
        this.tab.addNode(new XmlNode("font").setAttribute("row", TecExcel.toString(row)).setAttribute("col", TecExcel.toString(column)).setAttribute("name", TecExcel.toString(font)));
        return this;
    }

    public TecExcel setAlign(int row, int column, AlignEnum align) {
        if (row < 0 || column < 0 || align == null) {
            return this;
        }
        this.removeRectIntersects(row, column, "align");
        this.removeCellEqual(row, column, "align");
        this.tab.addNode(new XmlNode("align").setAttribute("row", TecExcel.toString(row)).setAttribute("col", TecExcel.toString(column)).setAttribute("value", TecExcel.toString(align)));
        return this;
    }

    public TecExcel addTab(String name) {
        this.tab = new XmlNode("tab").setAttribute("name", name).setAttribute("order", TecExcel.toString(this.tabSequence++));
        this.document.addNode(this.tab);
        return this;
    }

    public TecExcel setMerge(int rowBegin, int columnBegin, int rowEnd, int columnEnd) {
        if (rowBegin > rowEnd || columnBegin > rowEnd) {
            return this;
        }
        this.removeRectIntersects(rowBegin, columnBegin, rowEnd, columnEnd, "merge");
        this.tab.addNode(new XmlNode("merge").setAttribute("rowBegin", TecExcel.toString(rowBegin)).setAttribute("rowEnd", TecExcel.toString(rowEnd)).setAttribute("colBegin", TecExcel.toString(columnBegin)).setAttribute("colEnd", TecExcel.toString(columnEnd)));
        return this;
    }

    public TecExcel setBox(int rowBegin, int columnBegin, int rowEnd, int columnEnd, int size, Color color) {
        if (rowBegin > rowEnd || columnBegin > rowEnd) {
            return this;
        }
        this.removeRectEqual(rowBegin, columnBegin, rowEnd, columnEnd, "box");
        this.tab.addNode(new XmlNode("box").setAttribute("rowBegin", TecExcel.toString(rowBegin)).setAttribute("rowEnd", TecExcel.toString(rowEnd)).setAttribute("colBegin", TecExcel.toString(columnBegin)).setAttribute("colEnd", TecExcel.toString(columnEnd)).setAttribute("size", TecExcel.toString(size)).setAttribute("color", TecExcel.toString(color)));
        return this;
    }

    public TecExcel setTabName(String name) {
        this.tab.setAttribute("name", name);
        return this;
    }

    public XmlNode toXmlNode() {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.document.write(output);
            return new XmlNode(new ByteArrayInputStream(output.toByteArray()), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void removeCellEqual(int row, int column, String tagName) {
        for (XmlNode node : this.tab.getNodesByTagName(tagName)) {
            int oRow = Integer.parseInt(node.getAttribute("row"));
            int oCol = Integer.parseInt(node.getAttribute("col"));
            if (row != oRow || column != oCol) continue;
            this.tab.getNodes().remove(node);
        }
    }

    protected void removeRectEqual(int rowBegin, int columnBegin, int rowEnd, int columnEnd, String tagName) {
        for (XmlNode node : this.tab.getNodesByTagName(tagName)) {
            int row0 = Integer.parseInt(node.getAttribute("rowBegin"));
            int row1 = Integer.parseInt(node.getAttribute("rowEnd"));
            int col0 = Integer.parseInt(node.getAttribute("colBegin"));
            int col1 = Integer.parseInt(node.getAttribute("colEnd"));
            if (rowBegin != row0 || rowEnd != row1 || columnBegin != col0 || columnEnd != col1) continue;
            this.tab.getNodes().remove(node);
        }
    }

    protected void removeRectIntersects(int row, int column, String tagName) {
        Rectangle tRect = new Rectangle(column, row, 1, 1);
        for (XmlNode mNode : this.tab.getNodesByTagName("merge")) {
            int col1;
            int row0 = Integer.parseInt(mNode.getAttribute("rowBegin"));
            int row1 = Integer.parseInt(mNode.getAttribute("rowEnd"));
            int col0 = Integer.parseInt(mNode.getAttribute("colBegin"));
            Rectangle mRect = new Rectangle(col0, row0, (col1 = Integer.parseInt(mNode.getAttribute("colEnd"))) - col0 + 1, row1 - row0 + 1);
            if (!tRect.intersects(mRect)) continue;
            for (XmlNode oNode : this.tab.getNodesByTagName(tagName)) {
                int oRow = Integer.parseInt(oNode.getAttribute("row"));
                int oCol = Integer.parseInt(oNode.getAttribute("col"));
                Rectangle oRect = new Rectangle(oCol, oRow, 1, 1);
                if (!oRect.intersects(mRect)) continue;
                this.tab.getNodes().remove(oNode);
            }
        }
    }

    protected void removeRectIntersects(int rowBegin, int columnBegin, int rowEnd, int columnEnd, String tagName) {
        Rectangle tRect = new Rectangle(columnBegin, rowBegin, columnEnd - columnBegin + 1, rowEnd - rowBegin + 1);
        for (XmlNode node : this.tab.getNodesByTagName(tagName)) {
            int col1;
            int row0 = Integer.parseInt(node.getAttribute("rowBegin"));
            int row1 = Integer.parseInt(node.getAttribute("rowEnd"));
            int col0 = Integer.parseInt(node.getAttribute("colBegin"));
            Rectangle oRect = new Rectangle(col0, row0, (col1 = Integer.parseInt(node.getAttribute("colEnd"))) - col0 + 1, row1 - row0 + 1);
            if (!tRect.intersects(oRect)) continue;
            this.tab.getNodes().remove(node);
        }
    }

    protected static String toString(Color color) {
        StringBuilder sb = new StringBuilder();
        sb.append("0x00");
        String value = Integer.toHexString((color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue()).toUpperCase();
        while (sb.length() + value.length() != 10) {
            sb.append('0');
        }
        sb.append(value);
        return sb.toString();
    }

    protected static String toString(Font font) {
        StringBuilder sb = new StringBuilder();
        sb.append(font.getName());
        if ((font.getStyle() & 1) == 1) {
            sb.append(' ');
            sb.append("bold");
        }
        if ((font.getStyle() & 2) == 2) {
            sb.append(' ');
            sb.append("italic");
        }
        sb.append(' ');
        sb.append(font.getSize());
        return sb.toString();
    }

    protected static String toString(AlignEnum align) {
        switch (align) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        return "unknown";
    }

    protected static String toString(int value) {
        return Integer.toString(value);
    }

    public static void main(String[] args) throws Exception {
        TecExcel c = new TecExcel();
        c.setTabName("a");
        c.setCell(-1, 1, "aaa");
        c.setCell(1, 1, "bbb");
        c.setBackColor(0, 0, Color.ORANGE);
        c.setCell(1, 1, "ccc");
        c.setBackColor(0, 0, Color.CYAN);
        c.addTab("b");
        c.setCell(2, 3, "___");
        c.setMerge(1, 1, 2, 2);
        c.setMerge(0, 0, 1, 1);
        c.setCell(0, 0, "aaa");
        c.setCell(1, 1, "bbb");
        c.setBackColor(0, 0, Color.ORANGE);
        c.setBackColor(1, 1, Color.CYAN);
        c.setBox(1, 1, 3, 3, 1, Color.YELLOW);
        c.setBox(1, 1, 3, 3, 1, Color.RED);
        c.setForeColor(0, 0, Color.ORANGE);
        c.setForeColor(1, 1, Color.CYAN);
        c.setFont(0, 0, new Font("Arial", 3, 16));
        c.setAlign(1, 1, AlignEnum.CENTER);
        System.out.println(c.toXmlNode());
        System.out.println(new XmlNode(new ByteArrayInputStream(c.toXmlNode().getBytes()), true));
    }

    public static enum AlignEnum {
        LEFT,
        CENTER,
        RIGHT;

    }
}

