package tecgraf.javautils.excel.v1;

import java.awt.Component;

import javax.swing.JTable;

/**
 * Interface responsvel por retornar o valor a ser impresso atravs de uma
 * estrutura de dados.
 * 
 * 
 * @author bbreder
 */
public interface ExcelTable {

  /**
   * Retorna o valor atravs de uma estrutura de dados
   * 
   * @param table
   * @param row
   * @param column
   * @param valueAt
   * @return valor a ser impresso
   */
  public Object getValue(JTable table, int row, int column, Object valueAt);

  /**
   * Retorna o formato da celula
   * 
   * @param table
   * 
   * @param row
   * @param column
   * @param style
   * @return formatador da celula
   */
  public ExcelStyle getStyle(JTable table, int row, int column,
    ExcelStyleTool style);

  /**
   * 
   * @param table
   * @param valueAt
   * @param column
   * @return o objeto do cabealho de colunbe
   */
  public Object getColumnHeaderValue(JTable table, int column, Object valueAt);

  /**
   * 
   * @param table
   * @param column
   * @param style
   * @return formatador pra clula do cabealho de coluna
   */
  public ExcelStyle getColumnHeaderStyle(JTable table, int column,
    ExcelStyleTool style);

  /**
   * 
   * @param table
   * @param rowComponent 
   * @param valueAt
   * @param row
   * @return o objeto do cabealho de linha
   */
  public Object getRowHeaderValue(JTable table, Component rowComponent, int row, Object valueAt);

  /**
   * 
   * @param table
   * @param rowComponent 
   * @param row
   * @param style
   * @return formatador pra clula do cabealho de linha
   */
  public ExcelStyle getRowHeaderStyle(JTable table, Component rowComponent,
  int row,
    ExcelStyleTool style);

  /**
   * Formata o valor do Corner
   * 
   * @param c
   * @return valor primitivo do componente
   */
  public Object getCorner(Component c);
  
   /**
   * Formata o valor da coluna
   * 
   * @param columnValue
   * @param columnIndex
   * @return valor a ser escrito
   */
  public String getColumn(Object columnValue, int columnIndex);

}
