package tecgraf.javautils.excel.v1.poi;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;

import tecgraf.javautils.excel.v1.ExcelStroke;

/**
 * Paleta de espessura de Excel
 * 
 * 
 * @author bbreder
 */
public abstract class PoiExcelStroke {

  /**
   * Retorna o codigo do stroke
   * 
   * @param stroke
   * @return codigo da cor
   */
  public static short get(ExcelStroke stroke) {
    switch (stroke) {
      case SIMPLE_THIN:
        return HSSFCellStyle.BORDER_THIN;
      case MEDIUM:
        return HSSFCellStyle.BORDER_MEDIUM;
      case DOUBLE_THIN:
        return HSSFCellStyle.BORDER_DOUBLE;
      default:
        return HSSFCellStyle.BORDER_THIN;
    }
  }

}
