package tecgraf.javautils.excel.v1.util;

import tecgraf.javautils.excel.v1.ExcelMerge;

/**
 * Implementao padro da interface de Merge
 * 
 * 
 * @author bbreder
 */
public class DefaultExcelMerge implements ExcelMerge {

  /** Coluna inicial */
  private final int columnBeginIndex;
  /** Coluna final */
  private final int columnEndIndex;
  /** Linha inicial */
  private final int rowBeginIndex;
  /** Linha final */
  private final int rowEndIndex;

  /**
   * Construtor padro
   * 
   * @param columnBeginIndex
   * @param columnEndIndex
   * @param rowBeginIndex
   * @param rowEndIndex
   */
  public DefaultExcelMerge(int columnBeginIndex, int columnEndIndex,
    int rowBeginIndex, int rowEndIndex) {
    super();
    this.columnBeginIndex = columnBeginIndex;
    this.columnEndIndex = columnEndIndex;
    this.rowBeginIndex = rowBeginIndex;
    this.rowEndIndex = rowEndIndex;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getColumnBeginIndex() {
    return this.columnBeginIndex;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getColumnEndIndex() {
    return this.columnEndIndex;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getRowBeginIndex() {
    return this.rowBeginIndex;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getRowEndIndex() {
    return this.rowEndIndex;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + columnBeginIndex;
    result = prime * result + columnEndIndex;
    result = prime * result + rowBeginIndex;
    result = prime * result + rowEndIndex;
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    DefaultExcelMerge other = (DefaultExcelMerge) obj;
    if (columnBeginIndex != other.columnBeginIndex) {
      return false;
    }
    if (columnEndIndex != other.columnEndIndex) {
      return false;
    }
    if (rowBeginIndex != other.rowBeginIndex) {
      return false;
    }
    if (rowEndIndex != other.rowEndIndex) {
      return false;
    }
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return "DefaultExcelMerge [columnBeginIndex=" + columnBeginIndex
      + ", columnEndIndex=" + columnEndIndex + ", rowBeginIndex="
      + rowBeginIndex + ", rowEndIndex=" + rowEndIndex + "]";
  }

}
