/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v1.poi;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Scanner;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import tecgraf.javautils.excel.v1.ExcelConfig;
import tecgraf.javautils.excel.v1.ExcelDataTool;
import tecgraf.javautils.excel.v1.poi.PoiExcelSheet;
import tecgraf.javautils.excel.v1.poi.PoiExcelTool;

public class PoiExcelDataTool
extends PoiExcelTool
implements ExcelDataTool {
    private LinkedList<Point> pointStack;
    private int maxColumn;
    private int maxRow;
    private int column;
    private int row;
    private String dateFormat = "dd/MM/yyyy";
    private int precision;
    public static final Object EMPTY_CELL = "";
    public static final Object BLANK_CELL = null;
    private int maxRowDeep;
    private Graphics2D graphic;

    public PoiExcelDataTool(PoiExcelSheet helper) {
        super(helper.getExcel().getWorkbook(), helper);
        this.setMaxRowDeep(Integer.MAX_VALUE);
        this.setCell(1, 1);
        this.maxColumn = 1;
        this.precision = 1;
    }

    @Override
    public ExcelDataTool pushCell() {
        if (this.pointStack == null) {
            this.pointStack = new LinkedList();
        }
        this.pointStack.push(new Point(this.column, this.row));
        return this;
    }

    @Override
    public ExcelDataTool popCell() {
        if (this.pointStack == null || this.pointStack.isEmpty()) {
            throw new IllegalArgumentException("A pilha de estado j\u00e1 est\u00e1 vazia");
        }
        Point point = this.pointStack.pop();
        this.row = point.y;
        this.column = point.x;
        return null;
    }

    @Override
    public ExcelDataTool setCell(int column, int row) {
        if (column < 1 || column > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("" + column);
        }
        if (row < 1 || row > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("" + row);
        }
        this.column = column;
        this.row = row;
        return this;
    }

    @Override
    public ExcelDataTool setRow(int row) {
        return this.setCell(this.getColumn(), row);
    }

    @Override
    public ExcelDataTool setColumn(int column) {
        return this.setCell(column, this.getRow());
    }

    @Override
    public ExcelDataTool setCell(int column, int row, String value) {
        if (column < 1 || row < 1) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            value = "";
        }
        value = value.replace("\r", "").replace("\n", "").replace("\t", "");
        this.setCell(column, row);
        this.maxColumn = Math.max(this.maxColumn, column);
        this.maxRow = Math.max(this.maxRow, row);
        HSSFCell cell = this.getPoiCell(column, row);
        cell.setCellType(1);
        cell.setCellValue((RichTextString)new HSSFRichTextString(value));
        return this;
    }

    @Override
    public ExcelDataTool setCell(int column, int row, double value) {
        if (column < 1 || row < 1) {
            throw new IllegalArgumentException();
        }
        this.setCell(column, row);
        this.maxColumn = Math.max(this.maxColumn, column);
        this.maxRow = Math.max(this.maxRow, row);
        HSSFCell cell = this.getPoiCell(column, row);
        cell.setCellType(0);
        double pow = Math.pow(10.0, this.precision);
        value = (double)Math.round(value * pow) / pow;
        cell.setCellValue(value);
        return this;
    }

    @Override
    public ExcelDataTool setCell(int column, int row, boolean value) {
        if (column < 1 || row < 1) {
            throw new IllegalArgumentException();
        }
        this.setCell(column, row);
        this.maxColumn = Math.max(this.maxColumn, column);
        this.maxRow = Math.max(this.maxRow, row);
        HSSFCell cell = this.getPoiCell(column, row);
        cell.setCellType(4);
        cell.setCellValue(value);
        return this;
    }

    @Override
    public ExcelDataTool setCell(int column, int row, Date value) {
        if (value == null || column < 1 || row < 1) {
            throw new IllegalArgumentException();
        }
        this.setCell(column, row);
        this.maxColumn = Math.max(this.maxColumn, column);
        this.maxRow = Math.max(this.maxRow, row);
        HSSFCell cell = this.getPoiCell(column, row);
        SimpleDateFormat format = new SimpleDateFormat(this.getDateFormat());
        cell.setCellValue((RichTextString)new HSSFRichTextString(format.format(value)));
        return this;
    }

    @Override
    public ExcelDataTool setCell(int column, int row, Object value) {
        if (value != null) {
            Double number = PoiExcelDataTool.isNumber(value);
            if (number != null) {
                this.setCell(column, row, number);
            } else if (String.class.isInstance(value)) {
                this.setCell(column, row, (String)value);
            } else if (Boolean.class.isInstance(value)) {
                this.setCell(column, row, ((Boolean)value).toString());
            } else if (Date.class.isInstance(value)) {
                this.setCell(column, row, new SimpleDateFormat(this.dateFormat).format((Date)value));
            } else {
                this.setCell(column, row, value.toString());
            }
        }
        return this;
    }

    @Override
    public ExcelDataTool setCellSameLine(int column, String value) {
        return this.setCell(column, this.getRow(), value);
    }

    @Override
    public ExcelDataTool setCellSameLine(int column, double value) {
        return this.setCell(column, this.getRow(), value);
    }

    @Override
    public ExcelDataTool setCellSameLine(int column, boolean value) {
        return this.setCell(column, this.getRow(), value);
    }

    @Override
    public ExcelDataTool setCellSameLine(int column, Date value) {
        return this.setCell(column, this.getRow(), value);
    }

    @Override
    public ExcelDataTool setCellSameColumn(int row, String value) {
        return this.setCell(this.getColumn(), row, value);
    }

    @Override
    public ExcelDataTool setCellSameColumn(int row, double value) {
        return this.setCell(this.getColumn(), row, value);
    }

    @Override
    public ExcelDataTool setCellSameColumn(int row, boolean value) {
        return this.setCell(this.getColumn(), row, value);
    }

    @Override
    public ExcelDataTool setCellSameColumn(int row, Date value) {
        return this.setCell(this.getColumn(), row, value);
    }

    @Override
    public ExcelDataTool setCellHorizontal(String value) {
        this.setCell(this.getColumn(), this.getRow(), value);
        return this.incColumn();
    }

    @Override
    public ExcelDataTool setCellHorizontal(double value) {
        this.setCell(this.getColumn(), this.getRow(), value);
        return this.incColumn();
    }

    @Override
    public ExcelDataTool setCellHorizontal(boolean value) {
        this.setCell(this.getColumn(), this.getRow(), value);
        return this.incColumn();
    }

    @Override
    public ExcelDataTool setCellHorizontal(Date value) {
        this.setCell(this.getColumn(), this.getRow(), value);
        return this.incColumn();
    }

    @Override
    public ExcelDataTool setCellHorizontal(Object value) {
        if (value != null) {
            Double number = PoiExcelDataTool.isNumber(value);
            if (number != null) {
                this.setCellHorizontal(number);
            } else if (String.class.isInstance(value)) {
                this.setCellHorizontal((String)value);
            } else if (Boolean.class.isInstance(value)) {
                this.setCellHorizontal(value);
            } else if (Date.class.isInstance(value)) {
                this.setCellHorizontal((Date)value);
            } else {
                this.setCellHorizontal(value.toString());
            }
        } else {
            this.incColumn();
        }
        return this;
    }

    @Override
    public ExcelDataTool setCellHorizontal(Object ... values) {
        if (values != null) {
            for (Object value : values) {
                this.setCellHorizontal(value);
            }
        }
        return this;
    }

    @Override
    public ExcelDataTool setCellHorizontal(int column, int row, Object ... values) {
        this.setCell(column, row);
        this.setCellHorizontal(values);
        return this;
    }

    @Override
    public ExcelDataTool setCellVertical(String value) {
        this.setCell(this.getColumn(), this.getRow(), value);
        return this.incRow();
    }

    @Override
    public ExcelDataTool setCellVertical(double value) {
        this.setCell(this.getColumn(), this.getRow(), value);
        return this.incRow();
    }

    @Override
    public ExcelDataTool setCellVertical(boolean value) {
        this.setCell(this.getColumn(), this.getRow(), value);
        return this.incRow();
    }

    @Override
    public ExcelDataTool setCellVertical(Date value) {
        this.setCell(this.getColumn(), this.getRow(), value);
        return this.incRow();
    }

    @Override
    public ExcelDataTool setCellVertical(Object value) {
        if (value != null) {
            Double number = PoiExcelDataTool.isNumber(value);
            if (number != null) {
                this.setCellVertical(number);
            } else if (String.class.isInstance(value)) {
                this.setCellVertical((String)value);
            } else if (Boolean.class.isInstance(value)) {
                this.setCellVertical(value);
            } else if (Date.class.isInstance(value)) {
                this.setCellVertical((Date)value);
            } else {
                this.setCellVertical(value.toString());
            }
        } else {
            this.incRow();
        }
        return this;
    }

    @Override
    public ExcelDataTool setCellVertical(Object ... values) {
        if (values != null) {
            for (Object value : values) {
                this.setCellVertical(value);
            }
        }
        return this;
    }

    @Override
    public ExcelDataTool setCellVertical(int column, int row, Object ... values) {
        this.setCell(column, row);
        this.setCellVertical(values);
        return this;
    }

    @Override
    public ExcelDataTool incColumn() {
        HSSFCell cell = this.getPoiCell(this.getColumn(), this.getRow());
        do {
            this.setCell(this.getColumn() + 1, this.getRow());
        } while (this.getPoiCell(this.getColumn(), this.getRow()).equals(cell));
        return this;
    }

    @Override
    public ExcelDataTool incRow() {
        HSSFCell cell = this.getPoiCell(this.getColumn(), this.getRow());
        do {
            this.setCell(this.getColumn(), this.getRow() + 1);
        } while (this.getPoiCell(this.getColumn(), this.getRow()).equals(cell));
        return this;
    }

    @Override
    public ExcelDataTool decColumn() {
        HSSFCell cell = this.getPoiCell(this.getColumn(), this.getRow());
        do {
            this.setCell(this.getColumn() - 1, this.getRow());
        } while (this.getPoiCell(this.getColumn(), this.getRow()).equals(cell));
        return this;
    }

    @Override
    public ExcelDataTool decRow() {
        HSSFCell cell = this.getPoiCell(this.getColumn(), this.getRow());
        do {
            this.setCell(this.getColumn(), this.getRow() + 1);
        } while (this.getPoiCell(this.getColumn(), this.getRow()).equals(cell));
        return this;
    }

    private HSSFCell getPoiCell(int column, int row) {
        return this.getSheet().getCellMerged(column, row);
    }

    private boolean hasCell(int columnIndex, int rowIndex) {
        for (int n = 0; n < this.getPoiSheet().getNumMergedRegions(); ++n) {
            CellRangeAddress region = this.getPoiSheet().getMergedRegion(n);
            if (!region.isInRange(rowIndex - 1, columnIndex - 1)) continue;
            return true;
        }
        HSSFSheet sheet = this.getSheet().getPoiSheet();
        HSSFRow row = sheet.getRow(rowIndex - 1);
        if (row == null) {
            return false;
        }
        HSSFCell cell = row.getCell(columnIndex - 1);
        return cell != null;
    }

    @Override
    public Object getCell(int columnIndex, int rowIndex) {
        if (!this.hasCell(columnIndex, rowIndex)) {
            return null;
        }
        HSSFCell cell = this.getPoiCell(columnIndex, rowIndex);
        switch (cell.getCellType()) {
            case 0: {
                return cell.getNumericCellValue();
            }
        }
        return cell.getRichStringCellValue().getString();
    }

    @Override
    public int getCellWidth(int col, int row) {
        Object cell = this.getCell(col, row);
        if (cell == null) {
            return 0;
        }
        if (this.graphic == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.graphic = ge.createGraphics(new BufferedImage(1, 1, 1));
        }
        HSSFCell poiCell = this.getPoiCell(col, row);
        short fontIndex = poiCell.getCellStyle().getFontIndex();
        HSSFFont poiFont = this.getWorkbook().getFontAt(fontIndex);
        String fontName = poiFont.getFontName();
        short fontHeightInPoints = poiFont.getFontHeightInPoints();
        Font font = new Font(fontName, 0, fontHeightInPoints);
        this.graphic.setFont(font);
        int width = this.graphic.getFontMetrics().stringWidth(cell.toString());
        if (poiFont.getBoldweight() > 0) {
            width = (int)((double)width * 1.2 + 10.0);
        }
        return width;
    }

    @Override
    public int getNumberPrecision() {
        return this.precision;
    }

    @Override
    public void setNumberPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getMaxRowDeep() {
        return this.maxRowDeep;
    }

    @Override
    public void setMaxRowDeep(int maxRowDeep) {
        this.maxRowDeep = maxRowDeep;
    }

    private static Double isNumber(Object object) {
        if (object == null) {
            return null;
        }
        String text = object.toString();
        if (text.trim().length() == 0) {
            return null;
        }
        if (Double.class.isInstance(object)) {
            return (Double)Double.class.cast(object);
        }
        if (Number.class.isInstance(object)) {
            return new Double(text);
        }
        if (Number.class.isInstance(object)) {
            return ((Number)Number.class.cast(object)).doubleValue();
        }
        Scanner scanner = new Scanner(object.toString().trim());
        scanner.useLocale(ExcelConfig.getLocale());
        if (scanner.hasNextDouble() || scanner.hasNextLong()) {
            double value = scanner.nextDouble();
            if (!scanner.hasNext()) {
                return value;
            }
        }
        try {
            return new Double(object.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int getMaxColumnUsed() {
        return this.maxColumn;
    }

    @Override
    public int getMaxRowUsed() {
        return this.maxRow;
    }

    public String toString() {
        return "PoiExcelDataTool [column=" + this.column + ", row=" + this.row + "]";
    }
}

