/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v1.poi;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import tecgraf.javautils.excel.v1.ExcelColor;
import tecgraf.javautils.excel.v1.ExcelStroke;
import tecgraf.javautils.excel.v1.ExcelStyle;
import tecgraf.javautils.excel.v1.ExcelStyleTool;
import tecgraf.javautils.excel.v1.poi.PoiExcel;
import tecgraf.javautils.excel.v1.poi.PoiExcelSheet;
import tecgraf.javautils.excel.v1.poi.PoiExcelStyle;
import tecgraf.javautils.excel.v1.poi.PoiExcelTool;

public class PoiExcelStyleTool
extends PoiExcelTool
implements ExcelStyleTool {
    private Map<String, ExcelStyle> styleNames = new HashMap<String, ExcelStyle>();
    private Map<HSSFCell, PoiExcelStyle> styles = new HashMap<HSSFCell, PoiExcelStyle>();
    private Map<PoiExcelStyle, PoiExcelStyle> cacheOfBoxStyle = new HashMap<PoiExcelStyle, PoiExcelStyle>();

    public PoiExcelStyleTool(PoiExcelSheet helper) {
        super(helper.getExcel().getWorkbook(), helper);
        this.confPalette();
    }

    private void confPalette() {
        HSSFPalette palette = this.getWorkbook().getCustomPalette();
        palette.setColorAtIndex((short)45, (byte)-1, (byte)-31, (byte)-31);
        palette.setColorAtIndex((short)17, (byte)-31, (byte)-1, (byte)-31);
        palette.setColorAtIndex((short)12, (byte)-31, (byte)-31, (byte)-1);
        palette.setColorAtIndex((short)13, (byte)-1, (byte)-1, (byte)-31);
    }

    @Override
    public ExcelStyle createStyle() {
        PoiExcelSheet sheet = this.getSheet();
        PoiExcel excel = sheet.getExcel();
        return excel.getFactory().buildExcelStyle(excel);
    }

    @Override
    public ExcelStyleTool setStyle(int column, int row, ExcelStyle style) {
        return this.setStyle(column, column, row, row, style);
    }

    @Override
    public ExcelStyleTool setStyleRow(int column, int rowBegin, int rowEnd, ExcelStyle style) {
        return this.setStyle(column, column, rowBegin, rowEnd, style);
    }

    @Override
    public ExcelStyleTool setStyleColumn(int columnBegin, int columnEnd, int row, ExcelStyle style) {
        return this.setStyle(columnBegin, columnEnd, row, row, style);
    }

    @Override
    public ExcelStyleTool setStyle(int columnBegin, int columnEnd, int rowBegin, int rowEnd, ExcelStyle jstyle) {
        for (int column = columnBegin; column <= columnEnd; ++column) {
            for (int row = rowBegin; row <= rowEnd; ++row) {
                HSSFCell cell = this.getSheet().getCellMerged(column, row);
                HSSFCellStyle style = (HSSFCellStyle)jstyle.getAdapter();
                this.styles.put(cell, (PoiExcelStyle)jstyle);
                cell.setCellStyle(style);
            }
        }
        return this;
    }

    @Override
    public ExcelStyleTool addBox(int column, int row, ExcelStroke stroke, ExcelColor color) {
        return this.addBox(column, column, row, row, stroke, color);
    }

    @Override
    public ExcelStyleTool addBoxRow(int column, int rowBegin, int rowEnd, ExcelStroke stroke, ExcelColor color) {
        return this.addBox(column, column, rowBegin, rowEnd, stroke, color);
    }

    @Override
    public ExcelStyleTool addBoxColumn(int columnBegin, int columnEnd, int row, ExcelStroke stroke, ExcelColor color) {
        return this.addBox(columnBegin, columnEnd, row, row, stroke, color);
    }

    @Override
    public ExcelStyleTool addBox(int columnBegin, int columnEnd, int rowBegin, int rowEnd, ExcelStroke stroke, ExcelColor color) {
        for (int row = rowBegin; row <= rowEnd; ++row) {
            for (int column = columnBegin; column <= columnEnd; ++column) {
                if (row != rowBegin && row != rowEnd && column != columnBegin && column != columnEnd) continue;
                PoiExcelStyle jstyle = this.getBoxStyle(column, row);
                if (jstyle == null) {
                    jstyle = new PoiExcelStyle(this.getWorkbook());
                    this.applyBorder(columnBegin, columnEnd, rowBegin, rowEnd, column, row, jstyle, stroke, color);
                } else {
                    jstyle = jstyle.clone();
                    this.applyBorder(columnBegin, columnEnd, rowBegin, rowEnd, column, row, jstyle, stroke, color);
                }
                PoiExcelStyle styleCache = this.cacheOfBoxStyle.get(jstyle);
                if (styleCache == null) {
                    this.cacheOfBoxStyle.put(jstyle, jstyle);
                    jstyle.buildAdapter();
                } else {
                    jstyle = styleCache;
                }
                HSSFCell cell = this.getSheet().getCell(column, row);
                cell.setCellStyle((HSSFCellStyle)jstyle.getAdapter());
                this.setStyle(column, row, jstyle);
            }
        }
        return this;
    }

    private void applyBorder(int columnBegin, int columnEnd, int rowBegin, int rowEnd, int column, int row, PoiExcelStyle style, ExcelStroke stroke, ExcelColor color) {
        if (color == null) {
            color = ExcelColor.BLACK;
        }
        if (row == rowBegin) {
            style.borderTop(stroke, color);
        }
        if (row == rowEnd) {
            style.borderBottom(stroke, color);
        }
        if (column == columnBegin) {
            style.borderLeft(stroke, color);
        }
        if (column == columnEnd) {
            style.borderRight(stroke, color);
        }
    }

    @Override
    public ExcelStyle getStyle(String key) {
        return this.styleNames.get(key);
    }

    @Override
    public void setStyle(String key, ExcelStyle style) {
        this.styleNames.put(key, style);
    }

    public PoiExcelStyle getBoxStyle(int columnIndex, int rowIndex) {
        HSSFCell cell = this.getSheet().getCell(columnIndex, rowIndex);
        PoiExcelStyle style = this.styles.get(cell);
        return style;
    }

    private void setStyle(int column, int row, PoiExcelStyle style) {
        HSSFCell cell = this.getSheet().getCell(column, row);
        this.styles.put(cell, style);
    }
}

