package tecgraf.javautils.gui.crud;

/**
 * Interface de edio de objetos em uma IHC
 * 
 * @author Tecgraf
 * @param <T> tipo do objeto envolvimento.
 */
public interface IRegistrationEditionPanel<T> {

  /**
   * Construo de um objeto a partir dos widgets de interface
   * 
   * @return objeto
   */
  public abstract T getObjectFromIHC();

  /**
   * Preenchimento da interface a partir de um objeto.
   * 
   * @param object objeto
   */
  public abstract void setObjectToIHC(T object);

  /**
   * Indica que a interface deve estar em modo <i>read-only</i>
   * 
   * @param flag indicativo
   */
  public abstract void setReadOnlyIHC(boolean flag);

  /**
   * Limpeza da interface grfica.
   */
  public abstract void clearIHC();
}
