/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.crud.gui.editbuttons;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.crud.IRegistrationDescriptor;
import tecgraf.javautils.gui.crud.gui.edition.RegistrationEditionPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationModeListener;

public class RegistrationEditButtonsPanel<M, I>
extends JPanel {
    private final JButton cancelButton;
    private final JButton confirmButton;

    public RegistrationEditButtonsPanel(RegistrationMainPanel<M, I> mainPanel, RegistrationEditionPanel<M, I> editPanel, IRegistrationDescriptor<M, I> descriptor) {
        this.cancelButton = new JButton(mainPanel.getString("button.cancel"));
        this.confirmButton = new JButton(mainPanel.getString("button.confirm"));
        GUIUtils.matchPreferredSizes(this.cancelButton, this.confirmButton);
        this.setAddModeListener(mainPanel);
        this.setViewModeListener(mainPanel);
        this.setEditModeListener(mainPanel);
        this.setCancelListener(mainPanel);
        this.setConfirmListener(mainPanel, editPanel, descriptor);
        this.setLayout(new FlowLayout(1));
        this.add(this.cancelButton);
        this.add(new JPanel());
        this.add(this.confirmButton);
    }

    private void setConfirmListener(final RegistrationMainPanel<M, I> mainPanel, final RegistrationEditionPanel<M, I> editPanel, final IRegistrationDescriptor<M, I> descriptor) {
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationMainPanel.Mode mode = mainPanel.getMode();
                switch (mode) {
                    case ADD: {
                        Object object = editPanel.getObjectFromIHC();
                        if (object == null) {
                            return;
                        }
                        boolean added = descriptor.addCallback(object);
                        if (!added) break;
                        mainPanel.refreshGUI();
                        mainPanel.setMode(RegistrationMainPanel.Mode.VIEW);
                        break;
                    }
                    case EDIT: {
                        boolean edited;
                        Object oldObj = mainPanel.getSelectedObject();
                        Object newObj = editPanel.getObjectFromIHC();
                        if (oldObj != null && newObj != null && !(edited = descriptor.editCallback(oldObj, newObj))) {
                            return;
                        }
                        mainPanel.refreshGUI();
                        mainPanel.setMode(RegistrationMainPanel.Mode.VIEW);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Bad mode detected!");
                    }
                }
            }
        });
    }

    private void setCancelListener(final RegistrationMainPanel<M, I> mainPanel) {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mainPanel.setMode(RegistrationMainPanel.Mode.VIEW);
                RegistrationEditButtonsPanel.this.confirmButton.setText(mainPanel.getString("button.confirm"));
            }
        });
    }

    private void setAddModeListener(final RegistrationMainPanel<M, I> mainPanel) {
        mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode == RegistrationMainPanel.Mode.ADD) {
                    RegistrationEditButtonsPanel.this.confirmButton.setEnabled(true);
                    RegistrationEditButtonsPanel.this.confirmButton.setText(mainPanel.getString("button.create"));
                    RegistrationEditButtonsPanel.this.cancelButton.setEnabled(true);
                }
            }
        });
    }

    private void setEditModeListener(final RegistrationMainPanel<M, I> mainPanel) {
        mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode == RegistrationMainPanel.Mode.EDIT) {
                    RegistrationEditButtonsPanel.this.confirmButton.setEnabled(true);
                    RegistrationEditButtonsPanel.this.confirmButton.setText(mainPanel.getString("button.confirm"));
                    RegistrationEditButtonsPanel.this.cancelButton.setEnabled(true);
                }
            }
        });
    }

    private void setViewModeListener(RegistrationMainPanel<M, I> mainPanel) {
        mainPanel.addModeListener(new RegistrationModeListener(){

            @Override
            public void modeChanged(RegistrationMainPanel.Mode oldMode, RegistrationMainPanel.Mode newMode) {
                if (newMode == RegistrationMainPanel.Mode.VIEW) {
                    RegistrationEditButtonsPanel.this.confirmButton.setEnabled(false);
                    RegistrationEditButtonsPanel.this.cancelButton.setEnabled(false);
                }
            }
        });
    }

    public void signalObjectEdited(boolean flag) {
        this.confirmButton.setEnabled(flag);
    }
}

