/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Font;
import java.util.BitSet;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.print.DefaultPrintableTable;
import tecgraf.javautils.gui.print.LargeColumnModel;

public class LargeColumnPrintableTable
extends DefaultPrintableTable {
    public LargeColumnPrintableTable(TableModel model, Font font, int largeCol) {
        this(model, font, largeCol, true, true);
    }

    public LargeColumnPrintableTable(TableModel model, Font font, int largeCol, boolean changeCellFont, boolean changeTextFont) {
        super(new LargeColumnModel(model, largeCol), font, changeCellFont, changeTextFont);
        this.adjustTableFormat();
    }

    private void adjustTableFormat() {
        LargeColumnModel model = (LargeColumnModel)LargeColumnModel.class.cast(this.getModel());
        int columnCount = model.getColumnCount();
        BitSet rows = model.getInsertedRows();
        int row = rows.nextSetBit(0);
        while (row >= 0) {
            this.joinColumns(row, 0, columnCount - 1);
            this.setLineBorderVisible(row - 1, row, false);
            row = rows.nextSetBit(row + 1);
        }
        this.setColumnBorderVisible(0, columnCount - 1, false);
        this.setAlignTableHeader(true);
        this.setInsets(2.0f, 1.0f);
    }

    @Override
    public void setCellFont(int fromRow, int toRow, int fromColumn, int toColumn, Font font) {
        int toViewCol;
        LargeColumnModel model = (LargeColumnModel)LargeColumnModel.class.cast(this.getModel());
        int fromViewCol = model.getViewColumnIndex(fromColumn);
        if (fromViewCol == -1) {
            fromViewCol = model.getViewColumnIndex(fromColumn + 1);
        }
        if ((toViewCol = model.getViewColumnIndex(toColumn)) == -1) {
            toViewCol = model.getViewColumnIndex(toColumn - 1);
        }
        int fromViewRow = model.getViewRowIndex(fromRow);
        int toViewRow = model.getViewRowIndex(toRow);
        super.setCellFont(fromViewRow, toViewRow, fromViewCol, toViewCol, font);
    }

    @Override
    public void setColumnPart(float[] columnPart) {
        LargeColumnModel model = (LargeColumnModel)LargeColumnModel.class.cast(this.getModel());
        float[] parts = new float[model.getColumnCount()];
        for (int col = 0; col < columnPart.length; ++col) {
            int viewCol = model.getViewColumnIndex(col);
            if (viewCol == -1) continue;
            parts[viewCol] = columnPart[col];
        }
        super.setColumnPart(parts);
    }
}

