/*
 * $Id: ColorButton.java 108625 2010-08-03 17:44:34Z pasti $
 */

package tecgraf.javautils.gui.colorbutton;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JColorChooser;

/**
 * Classe para criao de um boto de escolha de cores padro.
 * 
 * @see ColorButtonSample
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ColorButton extends JButton {

  /**
   * Lista de listeners de escolha do boto.
   */
  private final List<ColorButtonChoiceListener> listeners = new ArrayList<ColorButtonChoiceListener>();

  /**
   * Componente que invocou este dilogo, para janela modal.
   */
  private Component owner;

  /**
   * Mtodo de ajuste da callback de seleo de cor.
   * 
   * @param colorButton o boto a ser ajustado.
   */
  private final void adjustColorButton(final ColorButton colorButton) {
    colorButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        final Color oldColor = colorButton.getBackground();
        Color newColor = JColorChooser.showDialog(owner, "", oldColor);
        if (newColor == null) {
          newColor = oldColor;
        }
        colorButton.setBackground(newColor);
        for (int i = 0; i < listeners.size(); i++) {
          final ColorButtonChoiceListener lst = listeners.get(i);
          if (lst != null) {
            lst.colorChosen(colorButton, newColor);
          }
        }
      }
    });
  }

  /**
   * Consulta a cor corrente.
   * 
   * @return a cor corrente.
   */
  public final Color getColor() {
    return getBackground();
  }

  /**
   * Ajusta a cor corrente.
   * 
   * @param color a cor a ser ajustada.
   */
  public final void setColor(final Color color) {
    setBackground(color);
  }

  /**
   * Adio de um listener de escolha de cor no boto.
   * 
   * @param listener o listener (<code>ColorButtonListener</code>).
   * @see ColorButtonChoiceListener
   */
  public final void addColorButtonChoiceListener(
    final ColorButtonChoiceListener listener) {
    listeners.add(listener);
  }

  /**
   * Construtor padro que ajusta a callback.
   */
  public ColorButton() {
    super(" ");
    adjustColorButton(this);
  }

  /**
   * Cria o boto de escolha de cores.
   * 
   * @param color a cor inicial do boto.
   */
  public ColorButton(final Color color) {
    this(null, color);
  }

  /**
   * Cria o boto de escolha de cores.
   * 
   * @param owner componente pai para efeito de hierarquia de dilogos.
   * @param color a cor inicial do boto.
   */
  public ColorButton(final Component owner, final Color color) {
    super(" ");
    this.owner = owner;
    setBackground(color);
    adjustColorButton(this);
  }
}
