package tecgraf.javautils.gui.field;

/**
 * Evento de alterao de data no {@link DateDocument}
 * 
 */
public class DateEvent {

  private Long date;
  private boolean monthChanged;
  private boolean valueIsAdjusting;

  /**
   * Construtor
   * 
   * @param date nova data em milisegundos. <CODE>NULL</CODE> indica uma data
   *        errada ou campo vazio
   * @param monthChanged boolean para indicar se a nova data pertence ao mesmo
   *        ms e ano da anterior. No caso de uma data nula, o valor ser
   *        <CODE>FALSE</CODE>
   * @param valueIsAdjusting indica se  um evento em serie onde alteraes no
   *        valor ainda esto sendo feitas
   */
  public DateEvent(Long date, boolean monthChanged, boolean valueIsAdjusting) {
    this.date = date;
    this.monthChanged = monthChanged;
    this.valueIsAdjusting = valueIsAdjusting;
  }

  /**
   * Obtm a nova data em milisegundos.<CODE>NULL</CODE> indica uma data errada
   * ou campo vazio
   * 
   * @return long
   */
  public Long getDate() {
    return date;
  }

  /**
   * Indica se a nova data pertence ao mesmo ms e ano da data anterior.No caso
   * de uma data nula, o valor ser <CODE>FALSE</CODE>
   * 
   * @return boolean
   */
  public boolean isMonthChanged() {
    return monthChanged;
  }

  /**
   * Indica se  um evento em serie onde alteraes no valor ainda esto sendo
   * feitas
   * 
   * @return boolean
   */
  public boolean getValueIsAdjusting() {
    return valueIsAdjusting;
  }

  @Override
  public String toString() {
    return getDate() + " " + isMonthChanged() + " " + getValueIsAdjusting();
  }
}
