package tecgraf.javautils.gui.crud.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.JTextField;

import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;

/**
 * Utilitrio para sinalizar edio.
 * 
 * @author Tecgraf
 */
public class TextListeners {

  /**
   * Adiciona listener em campo de texto.
   * 
   * @param field campo de texto
   * @param panel painel
   */
  static public <M, I> void addTextListener(final JTextField field,
    final RegistrationMainPanel<M, I> panel) {
    field.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        panel.signalObjectEdited(true);
      }
    });

    field.addKeyListener(new KeyAdapter() {
      @Override
      public void keyPressed(KeyEvent e) {
        final int kc = e.getKeyCode();
        if (kc == KeyEvent.VK_UP || kc == KeyEvent.VK_DOWN
          || kc == KeyEvent.VK_RIGHT || kc == KeyEvent.VK_LEFT) {
          return;
        }
        if (kc == KeyEvent.VK_TAB || kc == KeyEvent.VK_PAGE_DOWN
          || kc == KeyEvent.VK_PAGE_UP || kc == KeyEvent.VK_HOME
          || kc == KeyEvent.VK_END) {
          return;
        }

        panel.signalObjectEdited(true);
      }
    });
  }
}
