package tecgraf.javautils.gui.table;

import java.util.ArrayList;
import java.util.List;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

/**
 * <p>
 * Modelo para tabelas em que cada objeto representando uma linha da tabela.
 * Este modelo utiliza instncias da interface
 * {@link tecgraf.javautils.gui.table.RowCellValueProvider} para obter os
 * valores das clulas.
 * </p>
 * INSTRUES PARA USO:<br>
 * Cada objeto da lista a ser passada para o modelo deve ter propriedades que
 * representem as colunas da tabela. O construtor recebe como parmetro os nomes
 * das colunas e um "provedor de valores" (instncia da
 * <code>RowCellValueProvider</code>) para obter a propriedade adequada para
 * cada coluna.
 * 
 * @author $Author: pasti $
 * 
 * @see RowTableModelSample 
 * @see tecgraf.javautils.gui.table.ObjectTableModel
 * @deprecated Esta classe no deve ser mais usada. Sua funcionalidade foi
 *             trocada por <b>tecgraf.javautils.gui.table.ObjectTableModel</b>.
 */
@Deprecated
public class RowTableModel extends AbstractTableModel {
  /** Lista de objetos representando linhas da tabela */
  private List rows;

  /** Nomes para os cabealhos das colunas */
  private String[] columnNames;

  /** Classes de cada coluna */
  private Class<?>[] columnClasses;

  /** Provedor que extrai os valores das clulas dos objetos-linha */
  private RowCellValueProvider cellValueProvider;

  /**
   * <p>
   * Cria o modelo.
   * </p>
   * IMPORTANTE: Este construtor ignora a classe das colunas, portanto somente
   * os renderizadores de coluna tero efeito com ele. Para usar renderizadores
   * de classe, utilize o construtor
   * {@link #RowTableModel(List, String[], Class[], RowCellValueProvider)}.
   * 
   * @param rows lista de objetos-linha.
   * @param colNames Nomes para os cabealhos das colunas.
   * @param provider provedor para extrair os valores das clulas dos
   *        objetos-linha.
   * 
   * @deprecated A classe RowCellValueProvider foi alterada para
   *             ObjectTableProvider.
   */
  @Deprecated
  public RowTableModel(List rows, String[] colNames,
    RowCellValueProvider provider) {
    this(rows, colNames, null, provider);
  }

  /**
   * Cria o modelo.
   * 
   * @param rows lista de objetos-linha.
   * @param colNames Nomes para os cabealhos das colunas.
   * @param colClasses Classes para cada coluna do modelo.
   * @param provider provedor para extrair os valores das clulas dos
   *        objetos-linha.
   * 
   * @deprecated A classe RowCellValueProvider foi alterada para
   *             ObjectTableProvider.
   */
  @Deprecated
  public RowTableModel(List rows, String[] colNames, Class<?>[] colClasses,
    RowCellValueProvider provider) {
    if (rows == null) {
      throw new IllegalArgumentException("rows == null");
    }
    if (colNames == null) {
      throw new IllegalArgumentException("colNames == null");
    }
    if (provider == null) {
      throw new IllegalArgumentException("provider == null");
    }
    this.rows = rows;
    this.columnNames = colNames;
    this.columnClasses = colClasses;
    this.cellValueProvider = provider;
  }

  /**
   * Obtm o <code>RowCellValueProvider</code>
   * 
   * @return RowCellValueProvider
   * 
   * @deprecated A classe RowCellValueProvider foi alterada para
   *             ObjectTableProvider.
   */
  @Deprecated
  public RowCellValueProvider getCellValueProvider() {
    return cellValueProvider;
  }

  /**
   * {@inheritDoc}
   */
  public int getRowCount() {
    return rows.size();
  }

  /**
   * {@inheritDoc}
   */
  public int getColumnCount() {
    return columnNames.length;
  }

  /**
   * {@inheritDoc}
   */
  public Object getValueAt(int rowIndex, int colIndex) {
    Object[] cellValues = cellValueProvider.getCellValues(rows.get(rowIndex));
    if (cellValues == null) {
      return "???";
    }
    return cellValues[colIndex];
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName(int colIndex) {
    return columnNames[colIndex];
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass(int colIndex) {
    if (columnClasses == null) {
      return super.getColumnClass(colIndex);
    }
    return columnClasses[colIndex];
  }

  /**
   * Remove todos os elementos de objetos.
   */
  public void clear() {
    int size = rows.size();
    this.rows = new ArrayList();
    fireTableRowsDeleted(0, size);
  }

  /**
   * Substitui a lista de objetos-linha.
   * 
   * @param newRows nova lista de objetos-linha.
   * 
   * @throws IllegalArgumentException
   */
  public void setRows(List newRows) {
    if (newRows == null) {
      throw new IllegalArgumentException("rows == null");
    }
    this.rows = newRows;
    fireTableChanged(new TableModelEvent(this));
  }

  /**
   * Adiciona um objeto-linha  lista. Se j existir um objeto com o mesmo
   * identificador, este  sobrescrito (no permite duplicatas).
   * 
   * @param row objeto-linha a ser adicionado.
   * 
   * @throws IllegalArgumentException
   */
  public void add(Object row) {
    if (row == null) {
      throw new IllegalArgumentException("row == null");
    }
    int index = rows.indexOf(row);
    if (index != -1) {
      rows.set(index, row);
      fireTableRowsUpdated(index, index);
    }
    else {
      rows.add(row);
      index = rows.indexOf(row);
      fireTableRowsInserted(index, index);
    }
  }

  /**
   * Remove um objeto-linha da lista.
   * 
   * @param row objeto-linha a ser removido.
   * 
   * @return true se o objeto-linha for encontrado e removido com sucesso, false
   *         caso contrrio.
   * 
   * @throws IllegalArgumentException
   */
  public boolean remove(Object row) {
    if (row == null) {
      throw new IllegalArgumentException("row == null");
    }
    int index = rows.indexOf(row);
    if (index == -1) {
      return false;
    }
    rows.remove(index);
    fireTableRowsDeleted(index, index);
    return true;
  }

  /**
   * Modifica os dados de um objeto-linha da lista.
   * 
   * @param row objeto-linha a ser modificado.
   * 
   * @return true caso o objeto tenha sido modificado com sucesso, false caso
   *         este no tenha sido encontrado.
   * 
   * @throws IllegalArgumentException
   */
  public boolean modify(Object row) {
    if (row == null) {
      throw new IllegalArgumentException("row == null");
    }
    int index = rows.indexOf(row);
    if (index == -1) {
      return false;
    }
    rows.set(index, row);
    fireTableRowsUpdated(index, index);
    return true;
  }

  /**
   * Obtm a lista de objetos-linha atualizada.
   * 
   * @return lista de objetos-linha.
   */
  public List getRows() {
    return rows;
  }

  /**
   * Obtm um objeto-linha especfico.
   * 
   * @param rowIndex ndice do objeto-linha
   * 
   * @return o objeto-linha solicitado, ou null
   * 
   * @throws IndexOutOfBoundsException
   */
  public Object getRow(int rowIndex) {
    if (rowIndex < 0 || rowIndex >= rows.size()) {
      throw new IndexOutOfBoundsException("rowIndex=" + rowIndex);
    }
    return rows.get(rowIndex);
  }
}
