/*
 * Detalhes da ltima alterao:
 *
 * $Author: rodrigoh $
 * $Date: 2005-12-08 12:00:45 -0200 (Thu, 08 Dec 2005) $
 * $Revision: 2007 $
 */
package tecgraf.javautils.gui.wizard;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * Representa um ouvinte de eventos de mudana de estado que notifica a um
 * passo que tal evento ocorreu.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class WasChangedChangeListener implements ChangeListener {
  /** O passo que ser notificado. */
  private Step step;

  public void stateChanged(ChangeEvent e) {
    this.step.notifyChanged();
  }

  /**
   * Cria um ouvinte de eventos de mudana de estado que notificar a um passo
   * da ocorrncia desse evento.
   *
   * @param step O passo a ser notificado.
   */
  public WasChangedChangeListener(Step step) {
    this.step = step;
  }
}
