/*
 * $Id: BorderUtil.java 98073 2009-10-26 19:26:33Z clinio $
 */
package tecgraf.javautils.gui;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;

/**
 * Utilitrio para criao de bordas em componentes de interface.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class BorderUtil {

  /**
   * Margem de criao de bordas
   */
  final static private int BRD_GAP = 3;

  
  /**
   * Colocao de uma borda com linha e texto em um componente.
   * 
   * @param component o componente a ser colocado sob a borda.
   * @param title o ttulo a ser colocado.
   */
  public static void setEtchedBorder(final JComponent component,
    final String title) {
    component.setBorder(BorderFactory.createCompoundBorder(BorderFactory
      .createEmptyBorder(BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
        BorderUtil.BRD_GAP, BorderUtil.BRD_GAP), BorderFactory
      .createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory
        .createEmptyBorder(BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
          BorderUtil.BRD_GAP, BorderUtil.BRD_GAP))));
  }

  /**
   * Colocao de uma borda de linha em um componente.
   * 
   * @param component o componente a ser colocado sob a borda.
   */
  public static void setLinedBorder(final JComponent component) {
    BorderUtil.setTitledBorder(component, "");
  }

  /**
   * Colocao de uma borda rebaixada em um componente.
   * 
   * @param component o componente a ser colocado sob a borda.
   */
  public static void setLowBorder(final JComponent component) {
    final CompoundBorder border =
      BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(
        BorderUtil.BRD_GAP, BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
        BorderUtil.BRD_GAP), BorderFactory.createCompoundBorder(BorderFactory
        .createLoweredBevelBorder(), BorderFactory.createEmptyBorder(
        BorderUtil.BRD_GAP, BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
        BorderUtil.BRD_GAP)));
    component.setBorder(border);
  }

  /**
   * Colocao de uma borda com linha e texto em um componente.
   * 
   * @param component o componente a ser colocado sob a borda.
   * @param title o ttulo a ser colocado.
   */
  public static void setTitledBorder(final JComponent component,
    final String title) {
    component.setBorder(BorderFactory.createCompoundBorder(BorderFactory
      .createEmptyBorder(BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
        BorderUtil.BRD_GAP, BorderUtil.BRD_GAP), BorderFactory
      .createCompoundBorder(BorderFactory.createTitledBorder(title),
        BorderFactory.createEmptyBorder(BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
          BorderUtil.BRD_GAP, BorderUtil.BRD_GAP))));
  }
}
