package tecgraf.javautils.gui.crud;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

/**
 * Bundle.
 * 
 * @author Tecgraf
 */
public class RegistrationBundle extends ResourceBundle {

  /**
   * Armazenamento dos textos.
   */
  final private Properties properties = new Properties();
  /**
   * 
   */
  private final Locale locale;

  /**
   * Monta path de resource.
   * 
   * @param locale locale
   * @return path
   */
  private String getResourcePath(Locale locale) {
    final String dirName = "resources/bundles/";
    final String className = RegistrationBundle.class.getSimpleName();
    final String name = locale.getLanguage() + "_" + locale.getCountry();
    final String resPath = dirName + className + "_" + name + ".properties";
    return resPath;
  }

  /**
   * Busca stream.
   * 
   * @param locale locale
   * @return stream
   */
  private InputStream getResourceInputStream(Locale locale) {
    final String path = getResourcePath(locale);
    final InputStream stream =
      RegistrationBundle.class.getResourceAsStream(path);
    return stream;
  }

  /**
   * Construtor.
   * 
   * @param locale
   */
  public RegistrationBundle(final Locale locale) {
    this.locale = locale;
    final InputStream stream = getResourceInputStream(locale);
    if (stream != null) {
      try {
        properties.load(stream);
      }
      catch (IOException e) {
        final String locStr = locale.toString();
        final String className = this.getClass().getName();
        final String msg = className + ": Unsuported native locale: " + locStr;
        System.err.println(msg);
      }
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Object handleGetObject(String key) {
    if (key == null) {
      throw new NullPointerException("Null key detected!");
    }
    if (!properties.containsKey(key)) {
      return "<<" + key + ">>";
    }
    return properties.get(key);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Locale getLocale() {
    return locale;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Enumeration<String> getKeys() {
    final Set<String> keys = properties.stringPropertyNames();
    final Enumeration<String> parentKeys = parent.getKeys();
    if (parentKeys != null) {
      keys.addAll(Collections.list(parentKeys));
    }
    final Enumeration<String> enumeration = Collections.enumeration(keys);
    return enumeration;
  }
}
