/*
 * Detalhes da ltima alterao:
 *
 * $Author: rodrigoh $
 * $Date: 2005-12-08 12:00:45 -0200 (Thu, 08 Dec 2005) $
 * $Revision: 2007 $
 */
package tecgraf.javautils.gui.wizard;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

/**
 * Representa um ouvinte de eventos de item que notifica a um passo que tal
 * evento ocorreu.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class WasChangedItemListener implements ItemListener {
  /** O passo que ser notificado. */
  private Step step;

  public void itemStateChanged(ItemEvent e) {
    this.step.notifyChanged();
  }

  /**
   * Cria um ouvinte de eventos de item que notificar a um passo da ocorrncia
   * desse evento.
   *
   * @param step O passo a ser notificado.
   */
  public WasChangedItemListener(Step step) {
    this.step = step;
  }
}
